/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.scanner;

import io.datarouter.scanner.BaseLinkedScanner;
import io.datarouter.scanner.Scanner;
import java.util.Comparator;
import java.util.List;

public class SortingScanner<T>
extends BaseLinkedScanner<T, T> {
    private final Comparator<? super T> comparator;
    private boolean consumedInput;
    private Scanner<T> sortedScanner;

    public SortingScanner(Scanner<T> input, Comparator<? super T> comparator) {
        super(input);
        this.comparator = comparator;
        this.consumedInput = false;
    }

    @Override
    protected boolean advanceInternal() {
        if (!this.consumedInput) {
            List items = this.input.list();
            items.sort(this.comparator);
            this.sortedScanner = Scanner.of(items);
            this.consumedInput = true;
        }
        if (this.sortedScanner.advance()) {
            this.current = this.sortedScanner.current();
            return true;
        }
        return false;
    }
}

