/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.scanner;

import io.datarouter.scanner.Scanner;
import io.datarouter.scanner.ScannerTool;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Optional;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Collector;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;

public class ScannerStream<T>
implements Stream<T> {
    private final Scanner<T> scanner;

    public ScannerStream(Scanner<T> scanner) {
        this.scanner = scanner;
    }

    private Stream<T> nativeStream() {
        return ScannerTool.nativeStream(this.scanner);
    }

    private <R> R closeAndReturn(R result) {
        this.close();
        return result;
    }

    @Override
    public Iterator<T> iterator() {
        return this.scanner.iterator();
    }

    @Override
    public Spliterator<T> spliterator() {
        return ScannerTool.spliterator(this.scanner);
    }

    @Override
    public boolean isParallel() {
        return false;
    }

    @Override
    public Stream<T> sequential() {
        return this;
    }

    @Override
    public Stream<T> parallel() {
        return this;
    }

    @Override
    public Stream<T> unordered() {
        return this;
    }

    @Override
    public Stream<T> onClose(Runnable closeHandler) {
        return (Stream)this.nativeStream().onClose(closeHandler);
    }

    @Override
    public void close() {
        this.scanner.close();
    }

    @Override
    public IntStream mapToInt(ToIntFunction<? super T> mapper) {
        return this.nativeStream().mapToInt(mapper);
    }

    @Override
    public LongStream mapToLong(ToLongFunction<? super T> mapper) {
        return this.nativeStream().mapToLong(mapper);
    }

    @Override
    public DoubleStream mapToDouble(ToDoubleFunction<? super T> mapper) {
        return this.nativeStream().mapToDouble(mapper);
    }

    @Override
    public Stream<T> distinct() {
        return this.scanner.distinct().stream();
    }

    @Override
    public Stream<T> filter(Predicate<? super T> predicate) {
        return this.scanner.include(predicate).stream();
    }

    @Override
    public <R> Stream<R> map(Function<? super T, ? extends R> mapper) {
        Scanner<R> mappedScanner = this.scanner.map(mapper);
        return mappedScanner.stream();
    }

    @Override
    public Stream<T> peek(Consumer<? super T> action) {
        return this.scanner.each(action).stream();
    }

    @Override
    public Stream<T> limit(long limit) {
        return this.scanner.limit(limit).stream();
    }

    @Override
    public Stream<T> skip(long numToSkip) {
        return this.scanner.skip(numToSkip).stream();
    }

    @Override
    public Stream<T> sorted() {
        return this.scanner.sort().stream();
    }

    @Override
    public Stream<T> sorted(Comparator<? super T> comparator) {
        return this.scanner.sort(comparator).stream();
    }

    @Override
    public boolean anyMatch(Predicate<? super T> predicate) {
        return this.scanner.anyMatch(predicate);
    }

    @Override
    public boolean allMatch(Predicate<? super T> predicate) {
        return this.scanner.allMatch(predicate);
    }

    @Override
    public long count() {
        return this.scanner.count();
    }

    @Override
    public Optional<T> findAny() {
        return this.scanner.findFirst();
    }

    @Override
    public Optional<T> findFirst() {
        return this.scanner.findFirst();
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        this.scanner.forEach(action);
    }

    @Override
    public void forEachOrdered(Consumer<? super T> action) {
        this.scanner.forEach(action);
    }

    @Override
    public Optional<T> max(Comparator<? super T> comparator) {
        return this.scanner.findMax(comparator);
    }

    @Override
    public Optional<T> min(Comparator<? super T> comparator) {
        return this.scanner.findMin(comparator);
    }

    @Override
    public boolean noneMatch(Predicate<? super T> predicate) {
        return this.scanner.noneMatch(predicate);
    }

    @Override
    public Object[] toArray() {
        return this.scanner.toArray();
    }

    @Override
    public <A> A[] toArray(IntFunction<A[]> generator) {
        return this.closeAndReturn(this.nativeStream().toArray(generator));
    }

    @Override
    public T reduce(T identity, BinaryOperator<T> accumulator) {
        return this.closeAndReturn(this.nativeStream().reduce(identity, accumulator));
    }

    @Override
    public Optional<T> reduce(BinaryOperator<T> accumulator) {
        return this.closeAndReturn(this.nativeStream().reduce(accumulator));
    }

    @Override
    public <U> U reduce(U identity, BiFunction<U, ? super T, U> accumulator, BinaryOperator<U> combiner) {
        return this.closeAndReturn(this.nativeStream().reduce(identity, accumulator, combiner));
    }

    @Override
    public <R> R collect(Supplier<R> supplier, BiConsumer<R, ? super T> accumulator, BiConsumer<R, R> combiner) {
        return this.closeAndReturn(this.nativeStream().collect(supplier, accumulator, combiner));
    }

    @Override
    public <R, A> R collect(Collector<? super T, A, R> collector) {
        return this.closeAndReturn(this.nativeStream().collect(collector));
    }

    @Override
    public <R> Stream<R> flatMap(Function<? super T, ? extends Stream<? extends R>> mapper) {
        return this.nativeStream().flatMap(mapper);
    }

    @Override
    public IntStream flatMapToInt(Function<? super T, ? extends IntStream> mapper) {
        return this.nativeStream().flatMapToInt(mapper);
    }

    @Override
    public LongStream flatMapToLong(Function<? super T, ? extends LongStream> mapper) {
        return this.nativeStream().flatMapToLong(mapper);
    }

    @Override
    public DoubleStream flatMapToDouble(Function<? super T, ? extends DoubleStream> mapper) {
        return this.nativeStream().flatMapToDouble(mapper);
    }
}

