/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.scanner;

import io.datarouter.scanner.EmptyScanner;
import io.datarouter.scanner.IteratorScanner;
import io.datarouter.scanner.Scanner;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ReverseListScanner<T>
implements Scanner<T> {
    private final List<T> list;
    private int index;

    public ReverseListScanner(List<T> list) {
        this.list = list;
        this.index = list.size();
    }

    public static <T> Scanner<T> of(List<T> list) {
        if (list.size() == 0) {
            return EmptyScanner.singleton();
        }
        if (list instanceof LinkedList) {
            LinkedList linkedList = (LinkedList)list;
            Iterator descendingIterator = linkedList.descendingIterator();
            return IteratorScanner.of(descendingIterator);
        }
        return new ReverseListScanner<T>(list);
    }

    @Override
    public boolean advance() {
        --this.index;
        return this.index >= 0;
    }

    @Override
    public T current() {
        return this.list.get(this.index);
    }
}

