/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.scanner;

import io.datarouter.scanner.BaseLinkedScanner;
import io.datarouter.scanner.Scanner;
import java.util.function.BiPredicate;
import java.util.function.Function;

public class DeduplicatingConsecutiveScanner<T, R>
extends BaseLinkedScanner<T, T> {
    private final Function<T, R> mapper;
    private final BiPredicate<R, R> equalsPredicate;
    private boolean hasSetCurrent = false;

    public DeduplicatingConsecutiveScanner(Scanner<T> input, Function<T, R> mapper, BiPredicate<R, R> equalsPredicate) {
        super(input);
        this.mapper = mapper;
        this.equalsPredicate = equalsPredicate;
    }

    @Override
    public boolean advanceInternal() {
        while (this.input.advance()) {
            if (this.hasSetCurrent && this.equalsPredicate.test(this.mapper.apply(this.current), this.mapper.apply(this.input.current()))) continue;
            this.current = this.input.current();
            this.hasSetCurrent = true;
            return true;
        }
        return false;
    }
}

