/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.scanner;

import io.datarouter.scanner.BaseScanner;
import io.datarouter.scanner.ComparableScanner;
import io.datarouter.scanner.Scanner;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollatingScanner<T>
extends BaseScanner<T> {
    private static final Logger logger = LoggerFactory.getLogger(CollatingScanner.class);
    private final List<Scanner<T>> inputs;
    private final Comparator<? super T> comparator;
    private final PriorityQueue<ComparableScanner<T>> priorityQueue;
    private boolean opened;
    private boolean closed;

    public CollatingScanner(List<Scanner<T>> inputs, Comparator<? super T> comparator) {
        this.inputs = inputs;
        this.comparator = comparator;
        this.priorityQueue = new PriorityQueue();
        this.opened = false;
        this.closed = false;
    }

    @Override
    public boolean advance() {
        ComparableScanner<T> firstScanner;
        if (this.closed) {
            return false;
        }
        if (!this.opened) {
            Scanner.of(this.inputs).map(input -> new ComparableScanner<T>(input, this.comparator)).include(Scanner::advance).forEach(this.priorityQueue::add);
            this.opened = true;
        }
        if ((firstScanner = this.priorityQueue.poll()) == null) {
            this.current = null;
            return false;
        }
        this.current = firstScanner.current();
        if (firstScanner.advance()) {
            this.priorityQueue.add(firstScanner);
        } else {
            firstScanner.close();
        }
        return true;
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        for (Scanner scanner : this.priorityQueue) {
            try {
                scanner.close();
            }
            catch (Exception e) {
                logger.warn("scanner exception on input.close", (Throwable)e);
            }
        }
        this.closed = true;
    }
}

