/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.scanner;

import io.datarouter.scanner.BaseScanner;
import io.datarouter.scanner.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseLinkedScanner<T, R>
extends BaseScanner<R> {
    private static final Logger logger = LoggerFactory.getLogger(BaseLinkedScanner.class);
    protected final Scanner<T> input;
    protected boolean closed;

    public BaseLinkedScanner(Scanner<T> input) {
        this.input = input;
        this.closed = false;
    }

    protected abstract boolean advanceInternal();

    @Override
    public final boolean advance() {
        if (this.closed) {
            return false;
        }
        try {
            if (this.advanceInternal()) {
                return true;
            }
        }
        catch (Exception e) {
            logger.info("scanner exception on advanceInternal", (Throwable)e);
            this.close();
            throw e;
        }
        this.close();
        return false;
    }

    protected void closeInternal() {
    }

    @Override
    public final void close() {
        if (this.closed) {
            return;
        }
        try {
            this.closeInternal();
        }
        catch (Exception e) {
            logger.warn("scanner exception on closeInternal", (Throwable)e);
        }
        try {
            this.input.close();
        }
        catch (Exception e) {
            logger.warn("scanner exception on input.close", (Throwable)e);
        }
        this.closed = true;
    }
}

