/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.scanner;

import io.datarouter.scanner.Scanner;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;

public class ScannerToMap<T, K, V, M extends Map<K, V>>
implements Function<Scanner<T>, M> {
    private final Function<T, K> keyFunction;
    private final Function<T, V> valueFunction;
    private final PutFunction<K, V, M> putFunction;
    private final Supplier<M> mapSupplier;

    private ScannerToMap(Function<T, K> keyFunction, Function<T, V> valueFunction, Replace replacePolicy, BinaryOperator<V> mergeFunction, Supplier<M> mapSupplier) {
        this.keyFunction = keyFunction;
        this.valueFunction = valueFunction;
        if (replacePolicy == Replace.ALWAYS) {
            this.putFunction = this::replaceAlways;
        } else if (replacePolicy == Replace.NULL_VALUES) {
            this.putFunction = this::replaceNullValues;
        } else if (replacePolicy == Replace.NULL_KEYS) {
            this.putFunction = this::replaceNullKeys;
        } else if (replacePolicy == Replace.NEVER) {
            this.putFunction = this::replaceNever;
        } else {
            Objects.requireNonNull(mergeFunction);
            this.putFunction = (key, value, map) -> {
                Object object = map.merge(key, value, mergeFunction);
            };
        }
        this.mapSupplier = mapSupplier;
    }

    @Override
    public M apply(Scanner<T> scanner) {
        Map map = (Map)this.mapSupplier.get();
        scanner.forEach(item -> this.putFunction.apply(this.keyFunction.apply(item), this.valueFunction.apply(item), map));
        return (M)map;
    }

    private void replaceAlways(K key, V value, M map) {
        map.put(key, value);
    }

    private void replaceNullValues(K key, V value, M map) {
        map.putIfAbsent(key, value);
    }

    private void replaceNullKeys(K key, V value, M map) {
        if (!map.containsKey(key)) {
            map.put(key, value);
        }
    }

    private void replaceNever(K key, V value, M map) {
        if (map.containsKey(key)) {
            throw new IllegalStateException(String.format("key %s already exists", key));
        }
        map.put(key, value);
    }

    public static <T> Function<Scanner<T>, Map<T, T>> of() {
        return new ScannerToMap(Function.identity(), Function.identity(), Replace.ALWAYS, null, HashMap::new);
    }

    public static <T, K> Function<Scanner<T>, Map<K, T>> of(Function<T, K> keyFunction) {
        return new ScannerToMap(keyFunction, Function.identity(), Replace.ALWAYS, null, HashMap::new);
    }

    public static <T, K, V> Function<Scanner<T>, Map<K, V>> of(Function<T, K> keyFunction, Function<T, V> valueFunction) {
        return new ScannerToMap<T, K, V, Map>(keyFunction, valueFunction, Replace.ALWAYS, null, HashMap::new);
    }

    public static <T, K, V> Function<Scanner<T>, Map<K, V>> of(Function<T, K> keyFunction, Function<T, V> valueFunction, Replace replacePolicy) {
        return new ScannerToMap<T, K, V, Map>(keyFunction, valueFunction, replacePolicy, null, HashMap::new);
    }

    public static <T, K, V> Function<Scanner<T>, Map<K, V>> of(Function<T, K> keyFunction, Function<T, V> valueFunction, BinaryOperator<V> mergeFunction) {
        return new ScannerToMap<T, K, V, Map>(keyFunction, valueFunction, null, mergeFunction, HashMap::new);
    }

    public static <T, K, M extends Map<K, T>> Function<Scanner<T>, M> ofSupplied(Function<T, K> keyFunction, Supplier<M> mapSupplier) {
        return new ScannerToMap(keyFunction, Function.identity(), Replace.ALWAYS, null, mapSupplier);
    }

    public static <T, K, V, M extends Map<K, V>> Function<Scanner<T>, M> ofSupplied(Function<T, K> keyFunction, Function<T, V> valueFunction, Supplier<M> mapSupplier) {
        return new ScannerToMap<T, K, V, M>(keyFunction, valueFunction, Replace.ALWAYS, null, mapSupplier);
    }

    public static <T, K, V, M extends Map<K, V>> Function<Scanner<T>, M> ofSupplied(Function<T, K> keyFunction, Function<T, V> valueFunction, Replace replacePolicy, Supplier<M> mapSupplier) {
        return new ScannerToMap<T, K, V, M>(keyFunction, valueFunction, replacePolicy, null, mapSupplier);
    }

    public static <T, K, V, M extends Map<K, V>> Function<Scanner<T>, M> ofSupplied(Function<T, K> keyFunction, Function<T, V> valueFunction, BinaryOperator<V> mergeFunction, Supplier<M> mapSupplier) {
        return new ScannerToMap<T, K, V, M>(keyFunction, valueFunction, null, mergeFunction, mapSupplier);
    }

    private static interface PutFunction<K, V, M> {
        public void apply(K var1, V var2, M var3);
    }

    public static enum Replace {
        ALWAYS,
        NULL_VALUES,
        NULL_KEYS,
        NEVER;

    }
}

