/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.redis.node;

import io.datarouter.bytes.ByteTool;
import io.datarouter.bytes.InputStreamTool;
import io.datarouter.client.redis.RedisBlobCodec;
import io.datarouter.client.redis.client.RedisClientManager;
import io.datarouter.client.redis.client.RedisOps;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.client.ClientType;
import io.datarouter.storage.file.Pathbean;
import io.datarouter.storage.file.PathbeanKey;
import io.datarouter.storage.node.NodeParams;
import io.datarouter.storage.node.op.raw.BlobStorage;
import io.datarouter.storage.node.type.physical.base.BasePhysicalNode;
import io.datarouter.storage.util.Subpath;
import io.datarouter.util.tuple.Twin;
import io.lettuce.core.Value;
import io.lettuce.core.cluster.api.async.RedisClusterAsyncCommands;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class RedisBlobNode
extends BasePhysicalNode<PathbeanKey, Pathbean, Pathbean.PathbeanFielder>
implements BlobStorage.PhysicalBlobStorageNode {
    private final ClientId clientId;
    private final String bucket;
    private final Subpath rootPath;
    private final Integer schemaVersion;
    private final RedisBlobCodec codec;
    private final RedisClientManager redisClientManager;
    private final RedisOps ops;

    public RedisBlobNode(NodeParams<PathbeanKey, Pathbean, Pathbean.PathbeanFielder> params, ClientType<?, ?> clientType, RedisClientManager redisClientManager) {
        super(params, clientType);
        this.clientId = params.getClientId();
        this.bucket = params.getPhysicalName();
        this.rootPath = params.getPath();
        this.schemaVersion = Optional.ofNullable(params.getSchemaVersion()).orElse(1);
        this.codec = new RedisBlobCodec(this.schemaVersion);
        this.redisClientManager = redisClientManager;
        this.ops = new RedisOps(this.client());
    }

    private RedisClusterAsyncCommands<byte[], byte[]> client() {
        return this.redisClientManager.getClient(this.clientId);
    }

    public String getBucket() {
        return this.bucket;
    }

    public Subpath getRootPath() {
        return this.rootPath;
    }

    public boolean exists(PathbeanKey key) {
        return this.ops.exists(this.codec.encodeKey(key));
    }

    public Optional<Long> length(PathbeanKey key) {
        byte[] byteKey = this.codec.encodeKey(key);
        return this.ops.find(byteKey).map(value -> ((byte[])value).length).map(Integer::longValue);
    }

    public byte[] read(PathbeanKey key) {
        byte[] byteKey = this.codec.encodeKey(key);
        return this.ops.find(byteKey).orElse(null);
    }

    public byte[] read(PathbeanKey key, long offset, int length) {
        byte[] byteKey = this.codec.encodeKey(key);
        return this.ops.mget(List.of(byteKey)).findFirst().map(Value::getValue).map(bytes -> ByteTool.copyOfRange((byte[])bytes, (int)((int)offset), (int)length)).orElse(null);
    }

    public Map<PathbeanKey, byte[]> read(List<PathbeanKey> keys) {
        return Map.of();
    }

    public Scanner<List<PathbeanKey>> scanKeysPaged(Subpath subpath) {
        throw new UnsupportedOperationException();
    }

    public Scanner<List<Pathbean>> scanPaged(Subpath subpath) {
        throw new UnsupportedOperationException();
    }

    public void write(PathbeanKey key, byte[] value) {
        this.ops.set((Twin<byte[]>)Twin.of((Object)this.codec.encodeKey(key), (Object)value));
    }

    public void write(PathbeanKey key, Scanner<byte[]> chunks) {
        byte[] bytes = (byte[])chunks.listTo(ByteTool::concatenate);
        this.ops.set((Twin<byte[]>)Twin.of((Object)this.codec.encodeKey(key), (Object)bytes));
    }

    public void write(PathbeanKey key, InputStream inputStream) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        InputStreamTool.transferTo((InputStream)inputStream, (OutputStream)baos);
        this.write(key, baos.toByteArray());
    }

    public void delete(PathbeanKey key) {
        this.ops.del(this.codec.encodeKey(key));
    }

    public void deleteAll(Subpath subpath) {
        throw new UnsupportedOperationException();
    }
}

