/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.redis;

import io.datarouter.bytes.ByteTool;
import io.datarouter.bytes.codec.intcodec.RawIntCodec;
import io.datarouter.model.field.FieldTool;
import io.datarouter.storage.file.PathbeanKey;
import java.util.List;

public class RedisBlobCodec {
    private static final int CODEC_VERSION = 1;
    private static final RawIntCodec RAW_INT_CODEC = RawIntCodec.INSTANCE;
    private final int schemaVersion;

    public RedisBlobCodec(int nodeVersion) {
        this.schemaVersion = nodeVersion;
    }

    public byte[] encodeKey(PathbeanKey pk) {
        byte[] codecVersion = RAW_INT_CODEC.encode(1);
        byte[] key = FieldTool.getConcatenatedValueBytes((List)pk.getFields());
        byte[] version = RAW_INT_CODEC.encode(this.schemaVersion);
        return ByteTool.concatenate2((byte[][])new byte[][]{codecVersion, version, key});
    }
}

