/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.redis.client;

import io.datarouter.storage.config.Config;
import java.time.Duration;

public class RedisRequestConfig {
    private static final boolean DEFAULT_IGNORE_EXCEPTION_FOR_READ = true;
    private static final boolean DEFAULT_IGNORE_EXCEPTION_FOR_WRITE = false;
    private static final Duration DEFAULT_TIMEOUT_FOR_READ = Duration.ofSeconds(3L);
    private static final Duration DEFAULT_TIMEOUT_FOR_WRITE = Duration.ofSeconds(3L);
    public final String caller;
    public final Duration timeout;
    public final boolean ignoreException;

    private RedisRequestConfig(String caller, Duration timeout, boolean ignoreException) {
        this.caller = caller;
        this.timeout = timeout;
        this.ignoreException = ignoreException;
    }

    public static RedisRequestConfig forRead(String caller, Config config) {
        return new RedisRequestConfig(caller, config.findTimeout().orElse(DEFAULT_TIMEOUT_FOR_READ), config.findIgnoreException().orElse(true));
    }

    public static RedisRequestConfig forWrite(String caller, Config config) {
        return new RedisRequestConfig(caller, config.findTimeout().orElse(DEFAULT_TIMEOUT_FOR_WRITE), config.findIgnoreException().orElse(false));
    }
}

