/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.opencensus.adapter;

import io.datarouter.instrumentation.trace.Tracer;
import io.datarouter.instrumentation.trace.TracerThreadLocal;
import io.datarouter.instrumentation.trace.W3TraceContext;
import io.datarouter.util.tracer.DatarouterTracer;
import io.opencensus.trace.AttributeValue;
import io.opencensus.trace.Span;
import io.opencensus.trace.Tracing;
import java.util.Optional;

public class DatarouterOpencensusTool {
    public static final String TRACEPARENT_ATTRIBUTE_KEY = "datarouterTraceparent";
    public static final String THREAD_ID_ATTRIBUTE_KEY = "datarouterThreadId";
    public static final String SEQUENCE_PARENT_ATTRIBUTE_KEY = "datarouterSequenceParent";

    public static Optional<Span> createOpencensusSpan() {
        Tracer tracer = TracerThreadLocal.get();
        if (!(tracer instanceof DatarouterTracer)) {
            return Optional.empty();
        }
        Span span = Tracing.getTracer().spanBuilderWithExplicitParent("datarouter binding span", null).startSpan();
        Tracing.getTracer().withSpan(span);
        String traceparent = ((W3TraceContext)tracer.getTraceContext().get()).getTraceparent().toString();
        span.putAttribute(TRACEPARENT_ATTRIBUTE_KEY, AttributeValue.stringAttributeValue((String)traceparent));
        span.putAttribute(THREAD_ID_ATTRIBUTE_KEY, AttributeValue.longAttributeValue((long)tracer.getCurrentThreadId()));
        span.putAttribute(SEQUENCE_PARENT_ATTRIBUTE_KEY, AttributeValue.longAttributeValue((long)tracer.getCurrentSpan().getSequence().intValue()));
        return Optional.of(span);
    }
}

