/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.metric.gauge.conveyor;

import io.datarouter.conveyor.BaseConveyor;
import io.datarouter.conveyor.ConveyorCounters;
import io.datarouter.conveyor.ConveyorGaugeRecorder;
import io.datarouter.conveyor.ConveyorGauges;
import io.datarouter.conveyor.ConveyorRunnable;
import io.datarouter.conveyor.MemoryBuffer;
import io.datarouter.instrumentation.gauge.GaugeBatchDto;
import io.datarouter.instrumentation.gauge.GaugeDto;
import io.datarouter.instrumentation.gauge.GaugePublisher;
import io.datarouter.web.exception.ExceptionRecorder;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GaugeMemoryToPublisherConveyor
extends BaseConveyor {
    private static final Logger logger = LoggerFactory.getLogger(GaugeMemoryToPublisherConveyor.class);
    private static final int BATCH_SIZE = 5000;
    private final MemoryBuffer<GaugeDto> buffer;
    private final GaugePublisher gaugePublisher;

    public GaugeMemoryToPublisherConveyor(String name, Supplier<Boolean> shouldRun, MemoryBuffer<GaugeDto> buffer, ExceptionRecorder exceptionRecorder, GaugePublisher gaugePublisher, ConveyorGauges conveyorGauges) {
        super(name, shouldRun, () -> false, exceptionRecorder, (ConveyorGaugeRecorder)conveyorGauges);
        this.buffer = buffer;
        this.gaugePublisher = gaugePublisher;
    }

    public BaseConveyor.ProcessBatchResult processBatch() {
        Instant beforePeek = Instant.now();
        List dtos = this.buffer.pollMultiWithLimit(5000);
        Instant afterPeek = Instant.now();
        this.gaugeRecorder.savePeekDurationMs((ConveyorRunnable)this, Duration.between(beforePeek, afterPeek).toMillis());
        if (dtos.isEmpty()) {
            return new BaseConveyor.ProcessBatchResult(false);
        }
        try {
            this.gaugePublisher.publish(new GaugeBatchDto(dtos));
            ConveyorCounters.incPutMultiOpAndDatabeans((ConveyorRunnable)this, (long)dtos.size());
        }
        catch (Exception putMultiException) {
            logger.warn("", (Throwable)putMultiException);
            ConveyorCounters.inc((ConveyorRunnable)this, (String)"putMulti exception", (long)1L);
        }
        return new BaseConveyor.ProcessBatchResult(this.isShuttingDown() || dtos.size() == 5000);
    }

    public boolean shouldRunOnShutdown() {
        return true;
    }
}

