/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.metric.gauge;

import io.datarouter.metric.dto.GaugeBinaryDto;
import io.datarouter.metric.gauge.GaugeDirectorySupplier;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.file.PathbeanKey;
import io.datarouter.storage.util.Subpath;
import io.datarouter.util.Ulid;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class GaugeDirectoryDao {
    @Inject
    private GaugeDirectorySupplier directory;

    public GaugeBinaryDto read(String filename) {
        return GaugeBinaryDto.decode(this.directory.getGaugeDirectory().read(PathbeanKey.of((String)filename)));
    }

    public void write(GaugeBinaryDto dto, Ulid ulid) {
        PathbeanKey key = PathbeanKey.of((String)ulid.value());
        this.directory.getGaugeDirectory().write(key, dto.encodeIndexed());
    }

    public Scanner<String> scanKeysAllowUnsorted() {
        return this.directory.getGaugeDirectory().scanKeys(Subpath.empty(), new Config().setAllowUnsortedScan(Boolean.valueOf(true))).map(PathbeanKey::getPathAndFile);
    }

    public void delete(String filename) {
        this.directory.getGaugeDirectory().delete(PathbeanKey.of((String)filename));
    }

    public void deleteAll() {
        this.directory.getGaugeDirectory().deleteAll(Subpath.empty());
    }
}

