/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.metric.gauge;

import io.datarouter.instrumentation.gauge.GaugeDto;
import io.datarouter.metric.config.DatarouterGaugeSettingRoot;
import io.datarouter.metric.gauge.conveyor.GaugeBuffers;
import io.datarouter.storage.config.properties.ServerName;
import io.datarouter.storage.config.properties.ServiceName;
import io.datarouter.storage.metric.Gauges;
import io.datarouter.util.Ulid;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DatabeanGauges
implements Gauges {
    private static final Logger logger = LoggerFactory.getLogger(DatabeanGauges.class);
    @Inject
    private ServiceName serviceName;
    @Inject
    private ServerName serverName;
    @Inject
    private GaugeBuffers buffers;
    @Inject
    private DatarouterGaugeSettingRoot settings;

    public void save(String key, long value) {
        if (!((Boolean)this.settings.saveGaugesToMemory.get()).booleanValue()) {
            return;
        }
        if (key == null || key.isBlank()) {
            logger.info("bad key");
        }
        GaugeDto dto = new GaugeDto(key, this.serviceName.get(), this.serverName.get(), new Ulid().value(), Long.valueOf(value));
        this.buffers.offer(dto);
    }
}

