/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.metric.counter.conveyor;

import io.datarouter.conveyor.BaseConveyor;
import io.datarouter.conveyor.ConveyorCounters;
import io.datarouter.conveyor.ConveyorGaugeRecorder;
import io.datarouter.conveyor.ConveyorGauges;
import io.datarouter.conveyor.ConveyorRunnable;
import io.datarouter.conveyor.MemoryBuffer;
import io.datarouter.metric.counter.collection.CountPublisher;
import io.datarouter.scanner.Scanner;
import io.datarouter.web.exception.ExceptionRecorder;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CountMemoryToPublisherConveyor
extends BaseConveyor {
    private static final Logger logger = LoggerFactory.getLogger(CountMemoryToPublisherConveyor.class);
    private static final int POLL_LIMIT = 5;
    private final MemoryBuffer<Map<Long, Map<String, Long>>> buffer;
    private final CountPublisher countPublisher;

    public CountMemoryToPublisherConveyor(String name, Supplier<Boolean> shouldRun, MemoryBuffer<Map<Long, Map<String, Long>>> buffer, ExceptionRecorder exceptionRecorder, CountPublisher countPublisher, ConveyorGauges conveyorGauges) {
        super(name, shouldRun, () -> false, exceptionRecorder, (ConveyorGaugeRecorder)conveyorGauges);
        this.buffer = buffer;
        this.countPublisher = countPublisher;
    }

    public BaseConveyor.ProcessBatchResult processBatch() {
        Instant beforePeek = Instant.now();
        List dtos = this.buffer.pollMultiWithLimit(5);
        Instant afterPeek = Instant.now();
        this.gaugeRecorder.savePeekDurationMs((ConveyorRunnable)this, Duration.between(beforePeek, afterPeek).toMillis());
        if (dtos.isEmpty()) {
            return new BaseConveyor.ProcessBatchResult(false);
        }
        dtos.forEach(this::publishCounts);
        return new BaseConveyor.ProcessBatchResult(this.isShuttingDown() || dtos.size() == 5);
    }

    private void publishCounts(Map<Long, Map<String, Long>> counts) {
        try {
            int numCounts = (Integer)Scanner.of(counts.values()).map(Map::size).reduce((Object)0, Integer::sum);
            logger.info("counts numPeriods={}, numNames={}", (Object)counts.size(), (Object)numCounts);
            this.countPublisher.publish(counts);
            ConveyorCounters.incPutMultiOpAndDatabeans((ConveyorRunnable)this, (long)numCounts);
        }
        catch (Exception putMultiException) {
            logger.warn("", (Throwable)putMultiException);
            ConveyorCounters.inc((ConveyorRunnable)this, (String)"putMulti exception", (long)1L);
        }
    }

    public boolean shouldRunOnShutdown() {
        return true;
    }
}

