/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.metric.counter.collection;

import io.datarouter.instrumentation.count.CountCollector;
import io.datarouter.metric.counter.collection.CountPartitions;
import io.datarouter.metric.counter.conveyor.CountBuffers;
import io.datarouter.storage.setting.Setting;
import io.datarouter.util.DateTool;
import io.datarouter.util.string.StringTool;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatarouterCountCollector
implements CountCollector {
    private static final Logger logger = LoggerFactory.getLogger(DatarouterCountCollector.class);
    public static final long PERIOD_GRANULARITY_MS = CountPartitions.PERIOD_5s.getPeriodMs();
    public static final int METRICS_INITIAL_CAPACITY = 512;
    private final long flushIntervalMs;
    private final CountBuffers countBuffers;
    private final Setting<Boolean> saveCounts;
    private HashMap<Long, Map<String, Long>> valueByNameByPeriodStartMs;
    private long minTimeMs;
    private long nextFlushMs;

    public DatarouterCountCollector(long flushIntervalMs, CountBuffers countBuffers, Setting<Boolean> saveCounts) {
        this.minTimeMs = DateTool.getPeriodStart((long)flushIntervalMs);
        this.flushIntervalMs = flushIntervalMs;
        this.nextFlushMs = this.minTimeMs + flushIntervalMs;
        this.valueByNameByPeriodStartMs = new HashMap();
        this.countBuffers = countBuffers;
        this.saveCounts = saveCounts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush(long flushingMs) {
        HashMap<Long, Map<String, Long>> snapshot;
        DatarouterCountCollector datarouterCountCollector = this;
        synchronized (datarouterCountCollector) {
            if (this.nextFlushMs != flushingMs) {
                return;
            }
            this.minTimeMs = flushingMs;
            this.nextFlushMs = flushingMs + this.flushIntervalMs;
            snapshot = this.valueByNameByPeriodStartMs;
            if (logger.isInfoEnabled()) {
                logger.info("flushing periods=[{}], currentFlush={}", (Object)snapshot.keySet().stream().map(String::valueOf).collect(Collectors.joining(",")), (Object)flushingMs);
            }
            this.valueByNameByPeriodStartMs = new HashMap();
        }
        if (((Boolean)this.saveCounts.get()).booleanValue() && !snapshot.isEmpty()) {
            this.countBuffers.offer(snapshot);
        }
    }

    public long increment(String key) {
        return this.increment(key, 1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long increment(String key, long delta) {
        long total;
        long timeMs = System.currentTimeMillis();
        if (timeMs >= this.nextFlushMs) {
            this.flush(this.nextFlushMs);
        }
        if (delta == 0L) {
            return 0L;
        }
        if (key.contains("\n") || key.contains("\t")) {
            IllegalArgumentException stackTrace = new IllegalArgumentException();
            logger.warn("discarding bad count key={}", (Object)key, (Object)stackTrace);
            return 0L;
        }
        key = DatarouterCountCollector.sanitizeName(key);
        DatarouterCountCollector datarouterCountCollector = this;
        synchronized (datarouterCountCollector) {
            timeMs = Long.max(System.currentTimeMillis(), this.minTimeMs);
            timeMs = Long.min(timeMs, this.nextFlushMs - 1L);
            long periodStartMs = DateTool.getPeriodStart((long)timeMs, (long)PERIOD_GRANULARITY_MS);
            total = this.valueByNameByPeriodStartMs.computeIfAbsent(periodStartMs, $ -> new HashMap(512)).merge(key, delta, Long::sum);
        }
        return total;
    }

    public void stopAndFlushAll() {
        this.flush(this.nextFlushMs);
    }

    private static String sanitizeName(String name) {
        String sanitized = StringTool.trimToSize((String)name, (int)255);
        sanitized = StringTool.removeNonStandardCharacters((String)sanitized);
        return sanitized;
    }
}

