/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.metric.counter;

import io.datarouter.binarydto.codec.BinaryDtoIndexedCodec;
import io.datarouter.binarydto.dto.BinaryDto;
import io.datarouter.binarydto.dto.BinaryDtoField;
import io.datarouter.scanner.Scanner;
import io.datarouter.util.Require;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class CountBinaryDto
extends BinaryDto<CountBinaryDto> {
    @BinaryDtoField(index=0)
    public final String ulid;
    @BinaryDtoField(index=1)
    public final String serviceName;
    @BinaryDtoField(index=2)
    public final String serverName;
    @BinaryDtoField(index=3)
    public final Long period;
    @BinaryDtoField(index=4)
    public final List<SingleCountBinaryDto> counts;

    private CountBinaryDto(String ulid, String serviceName, String serverName, Long period, List<SingleCountBinaryDto> counts) {
        this.ulid = Require.notBlank((String)ulid);
        this.serviceName = Require.notBlank((String)serviceName);
        this.serverName = Require.notBlank((String)serverName);
        this.period = (Long)Require.notNull((Object)period);
        Require.isFalse((boolean)counts.isEmpty());
        this.counts = counts;
    }

    public static List<CountBinaryDto> createSizedDtos(String ulid, String serviceName, String serverName, Map<Long, Map<String, Long>> counts, int batchSize) {
        return Scanner.of(counts.keySet()).concat(period -> Scanner.of(((Map)counts.get(period)).entrySet()).map(entry -> new SingleCountBinaryDto((Map.Entry<String, Long>)entry)).batch(CountBinaryDto.getLargestPeriodSize(counts, batchSize)).map(countBatch -> new CountBinaryDto(ulid, serviceName, serverName, (Long)period, (List<SingleCountBinaryDto>)countBatch))).list();
    }

    private static int getLargestPeriodSize(Map<Long, Map<String, Long>> counts, int batchSize) {
        if (batchSize == Integer.MAX_VALUE) {
            return Scanner.of(counts.values()).map(Map::size).findMax(Comparator.naturalOrder()).orElse(0);
        }
        return batchSize;
    }

    public static CountBinaryDto decode(byte[] bytes) {
        return (CountBinaryDto)BinaryDtoIndexedCodec.of(CountBinaryDto.class).decode(bytes);
    }

    public static class SingleCountBinaryDto
    extends BinaryDto<SingleCountBinaryDto> {
        @BinaryDtoField(index=0)
        public final String name;
        @BinaryDtoField(index=1)
        public final Long value;

        private SingleCountBinaryDto(Map.Entry<String, Long> entry) {
            this.name = (String)Require.notNull((Object)entry.getKey());
            this.value = (Long)Require.greaterThan((Comparable)((Long)Require.notNull((Object)entry.getValue())), (Comparable)Long.valueOf(0L));
        }
    }
}

