/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.memcached.codec;

import io.datarouter.client.memcached.codec.MemcachedKey;
import io.datarouter.storage.tally.TallyKey;
import io.datarouter.util.tuple.Pair;

public class MemcachedTallyCodec {
    private final String nodeName;
    private final int schemaVersion;

    public MemcachedTallyCodec(String nodeName, int schemaVersion) {
        this.nodeName = nodeName;
        this.schemaVersion = schemaVersion;
    }

    public String encodeKey(TallyKey pk) {
        return MemcachedKey.encode(this.nodeName, this.schemaVersion, pk);
    }

    public Pair<String, Long> decodeResult(Pair<String, Object> result) {
        MemcachedKey<TallyKey> memcachedKey = MemcachedKey.decode((String)result.getLeft(), TallyKey.class);
        TallyKey tallyKey = (TallyKey)memcachedKey.primaryKey;
        String stringKey = tallyKey.getId();
        String stringValue = (String)result.getRight();
        Long longValue = Long.parseLong(stringValue);
        return new Pair((Object)stringKey, (Object)longValue);
    }
}

