/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.memcached.codec;

import io.datarouter.client.memcached.codec.MemcachedKey;
import io.datarouter.model.databean.Databean;
import io.datarouter.model.databean.DatabeanTool;
import io.datarouter.model.field.Field;
import io.datarouter.model.field.FieldSetTool;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.storage.file.PathbeanKey;
import io.datarouter.util.tuple.Pair;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemcachedDatabeanCodec<PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>> {
    private static final Logger logger = LoggerFactory.getLogger(MemcachedDatabeanCodec.class);
    private static final int MEGABYTE = 0x100000;
    private final String nodeName;
    private final int schemaVersion;
    private final DatabeanFielder<PK, D> fielder;
    private final Supplier<D> databeanSupplier;
    private final Map<String, Field<?>> fieldByPrefixedName;

    public MemcachedDatabeanCodec(String nodeName, int schemaVersion, DatabeanFielder<PK, D> fielder, Supplier<D> databeanSupplier, Map<String, Field<?>> fieldByPrefixedName) {
        this.nodeName = nodeName;
        this.schemaVersion = schemaVersion;
        this.fielder = fielder;
        this.databeanSupplier = databeanSupplier;
        this.fieldByPrefixedName = fieldByPrefixedName;
    }

    public String encodeKey(PK pk) {
        return MemcachedKey.encode(this.nodeName, this.schemaVersion, pk);
    }

    public byte[] encode(D databean) {
        return DatabeanTool.getBytes(databean, this.fielder);
    }

    public Optional<Pair<String, byte[]>> encodeKeyValueIfValid(D databean) {
        byte[] value = this.encode(databean);
        if (value.length > 0x200000) {
            logger.warn("object too big for memcached length={} key={}", (Object)value.length, (Object)databean.getKey());
            return Optional.empty();
        }
        String key = this.encodeKey(databean.getKey());
        return Optional.of(new Pair((Object)key, (Object)value));
    }

    public Optional<Pair<PathbeanKey, byte[]>> encodeKeyToPathbeanKeyValueIfValid(D databean) {
        byte[] value = this.encode(databean);
        if (value.length > 0x200000) {
            logger.warn("object too big for memcached length={} key={}", (Object)value.length, (Object)databean.getKey());
            return Optional.empty();
        }
        PathbeanKey key = MemcachedKey.encodeToPathbeanKey(databean.getKey());
        return Optional.of(new Pair((Object)key, (Object)value));
    }

    public D decodeResultValue(Pair<String, Object> result) {
        byte[] byteValue = (byte[])result.getRight();
        return this.decodeBytes(byteValue);
    }

    public D decodeBytes(byte[] bytes) {
        return (D)((Databean)FieldSetTool.fieldSetFromBytes(this.databeanSupplier, this.fieldByPrefixedName, (byte[])bytes));
    }
}

