/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.memcached.codec;

import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.storage.util.PrimaryKeyPercentCodecTool;

public class MemcachedKey<PK extends PrimaryKey<PK>> {
    public static final int CODEC_VERSION = 3;
    private static final int NUM_TOKENS = 4;
    public final int codecVersion;
    public final String nodeName;
    public final int databeanVersion;
    public final PK primaryKey;

    public MemcachedKey(int codecVersion, String nodeName, int databeanVersion, PK primaryKey) {
        this.codecVersion = codecVersion;
        this.nodeName = nodeName;
        this.databeanVersion = databeanVersion;
        this.primaryKey = primaryKey;
    }

    public static String encode(String nodeName, int databeanVersion, PrimaryKey<?> pk) {
        String encodedPk = PrimaryKeyPercentCodecTool.encode(pk);
        return "3:" + nodeName + ":" + databeanVersion + ":" + encodedPk;
    }

    public static <PK extends PrimaryKey<PK>> MemcachedKey<PK> decode(String stringKey, Class<PK> pkClass) {
        String[] tokens = stringKey.split(":");
        if (tokens.length != 4) {
            String message = String.format("Incorrect number of key parts.  Expected=%s, found=%s, input=%s", 4, tokens.length, stringKey);
            throw new RuntimeException(message);
        }
        int codecVersion = Integer.parseInt(tokens[0]);
        String nodeName = tokens[1];
        int databeanVersion = Integer.parseInt(tokens[2]);
        PrimaryKey primaryKey = PrimaryKeyPercentCodecTool.decode(pkClass, (String)tokens[3]);
        return new MemcachedKey<PrimaryKey>(codecVersion, nodeName, databeanVersion, primaryKey);
    }
}

