/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.memcached.client;

import io.datarouter.client.memcached.client.MemcachedClientManager;
import io.datarouter.instrumentation.trace.TraceSpanFinisher;
import io.datarouter.instrumentation.trace.TraceSpanGroupType;
import io.datarouter.instrumentation.trace.TracerTool;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.client.ClientId;
import io.datarouter.util.tuple.Pair;
import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemcachedOps {
    private static final Logger logger = LoggerFactory.getLogger(MemcachedOps.class);
    private final MemcachedClientManager memcachedClientManager;

    public MemcachedOps(MemcachedClientManager memcachedClientManager) {
        this.memcachedClientManager = memcachedClientManager;
    }

    public void delete(ClientId clientId, String nodeName, String memcachedStringKey, Duration timeout) {
        Throwable throwable = null;
        Object var6_7 = null;
        try (TraceSpanFinisher $ = TracerTool.startSpan((String)(String.valueOf(nodeName) + " " + "delete"), (TraceSpanGroupType)TraceSpanGroupType.DATABASE);){
            long start = System.currentTimeMillis();
            try {
                this.memcachedClientManager.getSpyMemcachedClient(clientId).delete(memcachedStringKey).get(timeout.toMillis(), TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                TracerTool.appendToSpanInfo((String)"memcached timeout");
                long elapsedMs = System.currentTimeMillis() - start;
                String details = "timeout after " + elapsedMs + "ms";
                throw new RuntimeException(details, e);
            }
            catch (InterruptedException | ExecutionException e) {
                TracerTool.appendToSpanInfo((String)"memcached exception");
                throw new RuntimeException(e);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public Scanner<Pair<String, Object>> fetch(ClientId clientId, String nodeName, Collection<String> memcachedStringKeys, long timeoutMs, boolean ignoreExceptions) {
        if (memcachedStringKeys.isEmpty()) {
            return Scanner.empty();
        }
        long start = System.currentTimeMillis();
        Throwable throwable = null;
        Object var10_9 = null;
        try (TraceSpanFinisher $ = TracerTool.startSpan((String)(String.valueOf(nodeName) + " get bulk"), (TraceSpanGroupType)TraceSpanGroupType.DATABASE);){
            Map results = (Map)this.memcachedClientManager.getSpyMemcachedClient(clientId).asyncGetBulk(memcachedStringKeys).get(timeoutMs, TimeUnit.MILLISECONDS);
            TracerTool.appendToSpanInfo((TracerTool.TraceSpanInfoBuilder)new TracerTool.TraceSpanInfoBuilder().add("keys", (Object)memcachedStringKeys.size()).add("results", (Object)results.size()));
            return Scanner.of(results.entrySet()).map(entry -> new Pair((Object)((String)entry.getKey()), entry.getValue()));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public long increment(ClientId clientId, String memcachedStringKey, int delta, int expiration) {
        return this.memcachedClientManager.getSpyMemcachedClient(clientId).incr(memcachedStringKey, delta, delta, expiration);
    }

    public void set(ClientId clientId, String nodeName, String memcachedStringKey, int expiration, byte[] bytes) {
        Throwable throwable = null;
        Object var7_8 = null;
        try (TraceSpanFinisher $ = TracerTool.startSpan((String)(String.valueOf(nodeName) + " " + "set"), (TraceSpanGroupType)TraceSpanGroupType.DATABASE);){
            TracerTool.appendToSpanInfo((String)"bytes", (Object)bytes.length);
            this.memcachedClientManager.getSpyMemcachedClient(clientId).set(memcachedStringKey, expiration, bytes);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

