/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.memcached.node;

import io.datarouter.client.memcached.client.MemcachedClientManager;
import io.datarouter.client.memcached.client.MemcachedEncodedKey;
import io.datarouter.instrumentation.trace.TraceSpanFinisher;
import io.datarouter.instrumentation.trace.TracerTool;
import io.datarouter.model.databean.Databean;
import io.datarouter.model.field.FieldSetTool;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.client.ClientType;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.node.NodeParams;
import io.datarouter.storage.node.op.raw.read.TallyStorageReader;
import io.datarouter.storage.node.type.physical.base.BasePhysicalNode;
import io.datarouter.storage.tally.TallyKey;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemcachedReaderNode<PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>>
extends BasePhysicalNode<PK, D, F>
implements TallyStorageReader<PK, D> {
    private static final Logger logger = LoggerFactory.getLogger(MemcachedReaderNode.class);
    protected static final Boolean DEFAULT_IGNORE_EXCEPTION = true;
    protected final Integer databeanVersion;
    protected final MemcachedClientManager memcachedClientManager;
    protected final ClientId clientId;

    public MemcachedReaderNode(NodeParams<PK, D, F> params, ClientType<?, ?> clientType, MemcachedClientManager memcachedClientManager, ClientId clientId) {
        super(params, clientType);
        this.memcachedClientManager = memcachedClientManager;
        this.clientId = clientId;
        this.databeanVersion = Optional.ofNullable(params.getSchemaVersion()).orElse(1);
    }

    public boolean exists(PK key, Config config) {
        if (key == null) {
            return false;
        }
        return this.get(key, config) != null;
    }

    public D get(PK key, Config config) {
        if (key == null) {
            return null;
        }
        return (D)((Databean)this.getMulti(List.of(key), config).stream().findFirst().orElse(null));
    }

    public List<PK> getKeys(Collection<PK> keys, Config params) {
        if (keys == null || keys.isEmpty()) {
            return List.of();
        }
        return Scanner.of(this.getMulti(keys, params)).map(Databean::getKey).list();
    }

    public List<D> getMulti(Collection<PK> keys, Config config) {
        if (keys == null || keys.isEmpty()) {
            return List.of();
        }
        Map<String, Object> bytesByStringKey = this.fetchBytesByStringKey(keys, config);
        if (bytesByStringKey == null) {
            return List.of();
        }
        ArrayList<Databean> databeans = new ArrayList<Databean>(keys.size());
        for (Map.Entry<String, Object> entry : bytesByStringKey.entrySet()) {
            byte[] bytes = (byte[])entry.getValue();
            if (bytes.length == 0) {
                throw new RuntimeException("empty memcached response key=" + entry.getKey());
            }
            ByteArrayInputStream is = new ByteArrayInputStream(bytes);
            try {
                Databean databean = (Databean)FieldSetTool.fieldSetFromByteStreamKnownLength((Supplier)this.getFieldInfo().getDatabeanSupplier(), (Map)this.getFieldInfo().getFieldByPrefixedName(), (InputStream)is, (int)bytes.length);
                databeans.add(databean);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return databeans;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Map<String, Object> fetchBytesByStringKey(Collection<? extends PrimaryKey<?>> keys, Config config) {
        List<String> memcachedKeys = this.buildMemcachedKeys(keys);
        long start = 0L;
        Throwable throwable = null;
        Object var7_7 = null;
        try (TraceSpanFinisher $ = TracerTool.startSpan((String)(String.valueOf(this.getName()) + " get bulk"));){
            start = System.currentTimeMillis();
            Map results = (Map)this.memcachedClientManager.getSpyMemcachedClient(this.clientId).asyncGetBulk(memcachedKeys).get(config.getTimeout().toMillis(), TimeUnit.MILLISECONDS);
            TracerTool.appendToSpanInfo((TracerTool.TraceSpanInfoBuilder)new TracerTool.TraceSpanInfoBuilder().add("keys", (Object)memcachedKeys.size()).add("results", (Object)results.size()));
            return results;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    public Optional<Long> findTallyCount(String key, Config config) {
        if (key == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.getMultiTallyCount(List.of(key), config).get(key));
    }

    public Map<String, Long> getMultiTallyCount(Collection<String> keys, Config config) {
        if (keys == null || keys.isEmpty()) {
            return Collections.emptyMap();
        }
        Map bytesByStringKey = (Map)Scanner.of(keys).map(TallyKey::new).listTo(tallyKeys -> this.fetchBytesByStringKey((Collection<? extends PrimaryKey<?>>)tallyKeys, config));
        if (bytesByStringKey == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Long> results = new HashMap<String, Long>();
        for (Map.Entry entry : bytesByStringKey.entrySet()) {
            String string = (String)entry.getValue();
            MemcachedEncodedKey memcachedKey = MemcachedEncodedKey.parse((String)entry.getKey(), TallyKey.class);
            results.put(((TallyKey)memcachedKey.primaryKey).getId(), Long.parseLong(string));
        }
        return results;
    }

    protected String buildMemcachedKey(PrimaryKey<?> pk) {
        return this.buildMemcachedKeys(List.of(pk)).get(0);
    }

    protected List<String> buildMemcachedKeys(Collection<? extends PrimaryKey<?>> pks) {
        return MemcachedEncodedKey.getVersionedKeyStrings((String)this.getName(), (int)this.databeanVersion, pks);
    }
}

