/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.memcached.node;

import io.datarouter.client.memcached.client.MemcachedClientManager;
import io.datarouter.client.memcached.node.MemcachedReaderNode;
import io.datarouter.instrumentation.trace.TraceSpanFinisher;
import io.datarouter.instrumentation.trace.TracerTool;
import io.datarouter.model.databean.Databean;
import io.datarouter.model.databean.DatabeanTool;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.client.ClientType;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.node.NodeParams;
import io.datarouter.storage.node.op.raw.TallyStorage;
import io.datarouter.storage.tally.TallyKey;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemcachedNode<PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>>
extends MemcachedReaderNode<PK, D, F>
implements TallyStorage.PhysicalTallyStorageNode<PK, D, F> {
    private static final Logger logger = LoggerFactory.getLogger(MemcachedNode.class);
    protected static final int MEGABYTE = 0x100000;

    public MemcachedNode(NodeParams<PK, D, F> params, ClientType<?, ?> clientType, MemcachedClientManager memcachedClientManager, ClientId clientId) {
        super(params, clientType, memcachedClientManager, clientId);
    }

    public void put(D databean, Config config) {
        if (databean == null) {
            return;
        }
        this.putMulti(List.of(databean), config);
    }

    public void putMulti(Collection<D> databeans, Config config) {
        if (databeans == null || databeans.isEmpty()) {
            return;
        }
        for (Databean databean : databeans) {
            byte[] bytes = DatabeanTool.getBytes((Databean)databean, (DatabeanFielder)this.getFieldInfo().getSampleFielder());
            if (bytes.length > 0x200000) {
                logger.error("object too big for memcached length={} key={}", (Object)bytes.length, (Object)databean.getKey());
                return;
            }
            String memcachedKey = this.buildMemcachedKey(databean.getKey());
            int expiration = MemcachedNode.getExpiration(config);
            try {
                this.clientSet(memcachedKey, expiration, bytes);
            }
            catch (RuntimeException exception) {
                if (config.ignoreExceptionOrUse(DEFAULT_IGNORE_EXCEPTION).booleanValue()) {
                    logger.error("memcached error on " + memcachedKey, (Throwable)exception);
                    continue;
                }
                throw exception;
            }
        }
    }

    public void delete(PK key, Config config) {
        if (key == null) {
            return;
        }
        this.deleteByKey((PrimaryKey<?>)key, config);
    }

    public void deleteTally(String key, Config config) {
        this.deleteByKey((PrimaryKey<?>)new TallyKey(key), config);
    }

    public void deleteMulti(Collection<PK> keys, Config config) {
        if (keys == null) {
            return;
        }
        keys.forEach(key -> this.delete(key, config));
    }

    public void deleteAll(Config config) {
        throw new UnsupportedOperationException();
    }

    public Long incrementAndGetCount(String key, int delta, Config config) {
        if (key == null) {
            return null;
        }
        String memcachedKey = this.buildMemcachedKey((PrimaryKey<?>)new TallyKey(key));
        try {
            return this.clientIncr(memcachedKey, delta, MemcachedNode.getExpiration(config));
        }
        catch (RuntimeException exception) {
            if (config.ignoreExceptionOrUse(DEFAULT_IGNORE_EXCEPTION).booleanValue()) {
                logger.error("memcached error on " + memcachedKey, (Throwable)exception);
                return null;
            }
            throw exception;
        }
    }

    private void deleteByKey(PrimaryKey<?> pk, Config config) {
        String memcacheKey = this.buildMemcachedKey(pk);
        try {
            this.clientDelete(memcacheKey, config.getTimeout());
        }
        catch (Exception exception) {
            if (config.ignoreExceptionOrUse(DEFAULT_IGNORE_EXCEPTION).booleanValue()) {
                logger.error("memcached error on " + memcacheKey, (Throwable)exception);
            }
            throw exception;
        }
    }

    private void clientSet(String memcachedKey, int expiration, byte[] bytes) {
        Throwable throwable = null;
        Object var5_6 = null;
        try (TraceSpanFinisher $ = TracerTool.startSpan((String)(String.valueOf(this.getName()) + " " + "set"));){
            TracerTool.appendToSpanInfo((String)"bytes", (Object)bytes.length);
            this.memcachedClientManager.getSpyMemcachedClient(this.clientId).set(memcachedKey, expiration, bytes);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private long clientIncr(String memcacheKey, int delta, int expiration) {
        return this.memcachedClientManager.getSpyMemcachedClient(this.clientId).incr(memcacheKey, delta, delta, expiration);
    }

    private void clientDelete(String memcacheKey, Duration timeout) {
        Throwable throwable = null;
        Object var4_5 = null;
        try (TraceSpanFinisher $ = TracerTool.startSpan((String)(String.valueOf(this.getName()) + " " + "delete"));){
            long start = System.currentTimeMillis();
            try {
                this.memcachedClientManager.getSpyMemcachedClient(this.clientId).delete(memcacheKey).get(timeout.toMillis(), TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                TracerTool.appendToSpanInfo((String)"memcached timeout");
                String details = "timeout after " + (System.currentTimeMillis() - start) + "ms";
                throw new RuntimeException(details, e);
            }
            catch (InterruptedException | ExecutionException e) {
                TracerTool.appendToSpanInfo((String)"memcached exception");
                throw new RuntimeException(e);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static int getExpiration(Config config) {
        if (config == null) {
            return 0;
        }
        Long timeoutSeconds = config.getTtl() == null ? Long.MAX_VALUE : config.getTtl().toSeconds();
        Integer expiration = timeoutSeconds > Integer.MAX_VALUE ? Integer.MAX_VALUE : timeoutSeconds.intValue();
        return expiration;
    }
}

