/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.memcached.client;

import io.datarouter.client.memcached.client.MemcachedOptions;
import io.datarouter.client.memcached.client.SpyMemcachedClient;
import io.datarouter.client.memcached.client.SpyMemcachedClientHolder;
import io.datarouter.storage.client.BaseClientManager;
import io.datarouter.storage.client.ClientId;
import io.datarouter.util.timer.PhaseTimer;
import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.spy.memcached.ConnectionFactory;
import net.spy.memcached.KetamaConnectionFactory;
import net.spy.memcached.compat.log.SLF4JLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MemcachedClientManager
extends BaseClientManager {
    private static final Logger logger = LoggerFactory.getLogger(MemcachedClientManager.class);
    @Inject
    private SpyMemcachedClientHolder spyMemcachedClientHolder;
    @Inject
    private MemcachedOptions memcachedOptions;

    public void shutdown(ClientId clientId) {
        this.spyMemcachedClientHolder.get(clientId).shutdown();
    }

    protected void safeInitClient(ClientId clientId) {
        logger.info("activating BaseMemcached client " + clientId.getName());
        PhaseTimer timer = new PhaseTimer(clientId.getName());
        System.setProperty("net.spy.log.LoggerImpl", SLF4JLogger.class.getName());
        try {
            this.spyMemcachedClientHolder.register(clientId, this.buildSpyClient(clientId));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        logger.warn(timer.add("done").toString());
    }

    protected SpyMemcachedClient buildSpyClient(ClientId clientId) throws IOException {
        KetamaConnectionFactory connectionFactory = new KetamaConnectionFactory(){

            public long getOperationTimeout() {
                return 200L;
            }
        };
        return new SpyMemcachedClient((ConnectionFactory)connectionFactory, this.memcachedOptions.getServers(clientId.getName()));
    }

    public SpyMemcachedClient getSpyMemcachedClient(ClientId clientId) {
        this.initClient(clientId);
        return this.spyMemcachedClientHolder.get(clientId);
    }
}

