/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.memcached.web;

import io.datarouter.client.memcached.MemcachedClientType;
import io.datarouter.client.memcached.client.MemcachedClientManager;
import io.datarouter.client.memcached.client.MemcachedOptions;
import io.datarouter.client.memcached.client.SpyMemcachedClient;
import io.datarouter.storage.client.ClientId;
import io.datarouter.web.browse.DatarouterClientWebInspector;
import io.datarouter.web.browse.dto.DatarouterWebRequestParamsFactory;
import io.datarouter.web.config.ServletContextSupplier;
import io.datarouter.web.handler.mav.Mav;
import io.datarouter.web.handler.params.Params;
import io.datarouter.web.html.j2html.bootstrap4.Bootstrap4PageFactory;
import io.datarouter.web.requirejs.DatarouterWebRequireJsV2;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;

public class MemcachedWebInspector
implements DatarouterClientWebInspector {
    @Inject
    private MemcachedOptions memcachedOptions;
    @Inject
    private DatarouterWebRequestParamsFactory paramsFactory;
    @Inject
    private MemcachedClientManager memcachedClientManager;
    @Inject
    private Bootstrap4PageFactory pageFactory;
    @Inject
    private ServletContextSupplier servletContext;

    public Mav inspectClient(Params params, HttpServletRequest request) {
        DatarouterWebRequestParamsFactory datarouterWebRequestParamsFactory = this.paramsFactory;
        datarouterWebRequestParamsFactory.getClass();
        DatarouterWebRequestParamsFactory.DatarouterWebRequestParams clientParams = new DatarouterWebRequestParamsFactory.DatarouterWebRequestParams(datarouterWebRequestParamsFactory, params, MemcachedClientType.class);
        SpyMemcachedClient spyClient = this.memcachedClientManager.getSpyMemcachedClient(clientParams.getClientId());
        String clientName = clientParams.getClientId().getName();
        ContainerTag content = (ContainerTag)TagCreator.div((DomContent[])new DomContent[]{TagCreator.h2((String)("Datarouter " + clientName)), DatarouterClientWebInspector.buildNav((String)((ServletContext)this.servletContext.get()).getContextPath(), (String)clientName), TagCreator.h3((String)"Client Summary"), this.buildOverview(clientParams.getClientId()), this.buildStats(spyClient.getStats())}).withClass("container my-3");
        return this.pageFactory.startBuilder(request).withTitle("Datarouter Client - Memcached").withRequires(new String[]{DatarouterWebRequireJsV2.SORTTABLE}).withContent(content).buildMav();
    }

    public ContainerTag buildStats(Map<SocketAddress, Map<String, String>> stats) {
        ContainerTag allStats = TagCreator.div();
        stats.entrySet().stream().map(entry -> this.buildSingleNodeStats(((SocketAddress)entry.getKey()).toString(), (Map)entry.getValue())).forEach(arg_0 -> ((ContainerTag)allStats).with(arg_0));
        return allStats;
    }

    private ContainerTag buildSingleNodeStats(String node, Map<String, String> stats) {
        ContainerTag tbody = TagCreator.tbody();
        stats.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).map(entry -> TagCreator.tr((DomContent[])new DomContent[]{TagCreator.th((String)((String)entry.getKey())), TagCreator.td((String)((String)entry.getValue()))})).forEach(arg_0 -> ((ContainerTag)tbody).with(arg_0));
        ContainerTag table = (ContainerTag)TagCreator.table((DomContent[])new DomContent[]{tbody}).withClass("table table-striped table-hover table-sm");
        return TagCreator.div((DomContent[])new DomContent[]{TagCreator.h4((String)node), table});
    }

    private ContainerTag buildOverview(ClientId clientId) {
        List<ContainerTag> listElements = this.memcachedOptions.getServers(clientId.getName()).stream().map(InetSocketAddress::toString).map(TagCreator::li).collect(Collectors.toList());
        ContainerTag nodeList = TagCreator.ul((DomContent[])((DomContent[])listElements.toArray(new ContainerTag[listElements.size()])));
        return TagCreator.dl((DomContent[])new DomContent[]{TagCreator.dt((String)"Number of nodes:"), TagCreator.dd((String)String.valueOf(listElements.size())), TagCreator.dt((String)"Nodes:"), TagCreator.dd((DomContent[])new DomContent[]{nodeList})});
    }
}

