/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.memcached.ratelimiter;

import io.datarouter.client.memcached.node.MemcachedNode;
import io.datarouter.client.memcached.ratelimiter.TallyNodeFactory;
import io.datarouter.client.memcached.tally.Tally;
import io.datarouter.client.memcached.tally.TallyKey;
import io.datarouter.storage.Datarouter;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.dao.BaseDao;
import java.time.Duration;
import java.util.Collection;
import java.util.Map;

public abstract class BaseTallyDao
extends BaseDao {
    private final MemcachedNode<TallyKey, Tally, Tally.TallyFielder> node;

    public BaseTallyDao(Datarouter datarouter, TallyNodeFactory nodeFactory, ClientId clientId, int version) {
        super(datarouter);
        this.node = (MemcachedNode)datarouter.register(nodeFactory.create(clientId, version));
    }

    public Long incrementAndGetCount(String key, int delta, Duration ttl, Duration timeout) {
        Config config = new Config().setTtl(ttl).setTimeout(timeout);
        return this.node.incrementAndGetCount(key, delta, config);
    }

    public Map<String, Long> getMultiTallyCount(Collection<String> keys, Duration ttl, Duration timeout) {
        Config config = new Config().setTtl(ttl).setTimeout(timeout);
        return this.node.getMultiTallyCount(keys, config);
    }
}

