/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.memcached.codec;

import io.datarouter.client.memcached.util.MemcachedPathbeanResult;
import io.datarouter.client.memcached.util.MemcachedResult;
import io.datarouter.storage.file.PathbeanKey;
import io.datarouter.storage.util.Subpath;

public class MemcachedBlobCodec {
    private final Subpath rootPath;
    private final int rootPathLength;

    public MemcachedBlobCodec(Subpath rootPath) {
        this.rootPath = rootPath;
        this.rootPathLength = rootPath.toString().length();
    }

    public String encodeKey(PathbeanKey pk) {
        return this.rootPath + pk.getPathAndFile();
    }

    public PathbeanKey decodeKey(String stringKey) {
        String stringPk = stringKey.substring(this.rootPathLength);
        return PathbeanKey.of((String)stringPk);
    }

    public MemcachedPathbeanResult decodeResult(MemcachedResult<byte[]> result) {
        return new MemcachedPathbeanResult(PathbeanKey.of((String)result.key()), result.value());
    }
}

