/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.memcached.client;

import io.datarouter.client.memcached.client.BaseMemcachedClientManager;
import io.datarouter.client.memcached.codec.MemcachedBlobCodec;
import io.datarouter.client.memcached.codec.MemcachedTallyCodec;
import io.datarouter.client.memcached.node.MemcachedBlobNode;
import io.datarouter.client.memcached.node.MemcachedTallyNode;
import io.datarouter.model.databean.Databean;
import io.datarouter.model.entity.Entity;
import io.datarouter.model.key.entity.EntityKey;
import io.datarouter.model.key.primary.EntityPrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.model.util.CommonFieldSizes;
import io.datarouter.storage.client.ClientType;
import io.datarouter.storage.client.imp.BlobClientNodeFactory;
import io.datarouter.storage.client.imp.DatabeanClientNodeFactory;
import io.datarouter.storage.client.imp.TallyClientNodeFactory;
import io.datarouter.storage.config.properties.ServiceName;
import io.datarouter.storage.file.DatabaseBlob;
import io.datarouter.storage.file.DatabaseBlobKey;
import io.datarouter.storage.file.ReservedBlobPaths;
import io.datarouter.storage.node.DatabeanNodePrefix;
import io.datarouter.storage.node.DatabeanToBlobCodec;
import io.datarouter.storage.node.DatabeanToBlobNode;
import io.datarouter.storage.node.NodeParams;
import io.datarouter.storage.node.adapter.NodeAdapters;
import io.datarouter.storage.node.entity.EntityNodeParams;
import io.datarouter.storage.node.op.raw.BlobStorage;
import io.datarouter.storage.node.op.raw.MapStorage;
import io.datarouter.storage.node.op.raw.TallyStorage;
import io.datarouter.storage.node.type.physical.PhysicalNode;
import io.datarouter.storage.serialize.fieldcache.PhysicalDatabeanFieldInfo;
import io.datarouter.storage.tally.Tally;
import io.datarouter.storage.tally.TallyKey;
import io.datarouter.storage.util.Subpath;
import javax.inject.Singleton;

@Singleton
public class BaseMemcachedClientNodeFactory
implements BlobClientNodeFactory,
DatabeanClientNodeFactory,
TallyClientNodeFactory {
    private final ClientType<?, ?> memcachedClientType;
    private final ServiceName serviceName;
    private final BaseMemcachedClientManager memcachedClientManager;
    private final NodeAdapters nodeAdapters;

    public BaseMemcachedClientNodeFactory(ClientType<?, ?> memcachedClientType, ServiceName serviceName, BaseMemcachedClientManager memcachedClientManager, NodeAdapters nodeAdapters) {
        this.memcachedClientType = memcachedClientType;
        this.serviceName = serviceName;
        this.memcachedClientManager = memcachedClientManager;
        this.nodeAdapters = nodeAdapters;
    }

    public BlobStorage.PhysicalBlobStorageNode createBlobNode(NodeParams<DatabaseBlobKey, DatabaseBlob, DatabaseBlob.DatabaseBlobFielder> nodeParams) {
        MemcachedBlobCodec codec = new MemcachedBlobCodec(nodeParams.getPath());
        MemcachedBlobNode node = new MemcachedBlobNode(nodeParams, this.memcachedClientType, codec, this.memcachedClientManager.getLazyClient(nodeParams.getClientId()));
        return this.nodeAdapters.wrapBlobNode((BlobStorage.PhysicalBlobStorageNode)node);
    }

    public <EK extends EntityKey<EK>, E extends Entity<EK>, PK extends EntityPrimaryKey<EK, PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>> PhysicalNode<PK, D, F> createDatabeanNode(EntityNodeParams<EK, E> entityNodeParams, NodeParams<PK, D, F> nodeParams) {
        PhysicalDatabeanFieldInfo fieldInfo = new PhysicalDatabeanFieldInfo(nodeParams);
        Subpath path = new DatabeanNodePrefix(ReservedBlobPaths.DATABEAN, "1", this.serviceName.get(), "1", nodeParams, fieldInfo).makeShortenedSubpath();
        NodeParams blobParams = new NodeParams.NodeParamsBuilder(nodeParams).withPath(path).build();
        MemcachedBlobNode blobNode = new MemcachedBlobNode(this.castParams(blobParams), this.memcachedClientType, new MemcachedBlobCodec(path), this.memcachedClientManager.getLazyClient(nodeParams.getClientId()));
        DatabeanToBlobCodec databeanCodec = new DatabeanToBlobCodec(this.memcachedClientType.getName(), fieldInfo.getSampleFielder(), fieldInfo.getDatabeanSupplier(), fieldInfo.getFieldByPrefixedName(), path, 250, CommonFieldSizes.MEMCACHED_MAX_VALUE_LENGTH);
        DatabeanToBlobNode node = new DatabeanToBlobNode(nodeParams, this.memcachedClientType, (BlobStorage.PhysicalBlobStorageNode)blobNode, databeanCodec);
        return this.nodeAdapters.wrapDatabeanMapNode((MapStorage.PhysicalMapStorageNode)node);
    }

    private NodeParams<DatabaseBlobKey, DatabaseBlob, DatabaseBlob.DatabaseBlobFielder> castParams(NodeParams<?, ?, ?> params) {
        return params;
    }

    public TallyStorage.PhysicalTallyStorageNode createTallyNode(NodeParams<TallyKey, Tally, Tally.TallyFielder> nodeParams) {
        PhysicalDatabeanFieldInfo fieldInfo = new PhysicalDatabeanFieldInfo(nodeParams);
        Subpath path = new DatabeanNodePrefix(ReservedBlobPaths.TALLY, "1", this.serviceName.get(), "1", nodeParams, fieldInfo).makeShortenedSubpath();
        MemcachedTallyCodec tallyCodec = new MemcachedTallyCodec(this.memcachedClientType.getName(), path, 250);
        MemcachedTallyNode node = new MemcachedTallyNode(nodeParams, this.memcachedClientType, tallyCodec, this.memcachedClientManager.getLazyClient(nodeParams.getClientId()));
        return this.nodeAdapters.wrapTallyNode((TallyStorage.PhysicalTallyStorageNode)node);
    }
}

