/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.memcached.client;

import io.datarouter.client.memcached.client.DatarouterMemcachedClient;
import io.datarouter.client.memcached.client.MemcachedClientHolder;
import io.datarouter.storage.client.BaseClientManager;
import io.datarouter.storage.client.ClientId;
import io.datarouter.util.singletonsupplier.SingletonSupplier;
import io.datarouter.util.timer.PhaseTimer;
import java.util.function.Supplier;
import net.spy.memcached.compat.log.SLF4JLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseMemcachedClientManager
extends BaseClientManager {
    private static final Logger logger = LoggerFactory.getLogger(BaseMemcachedClientManager.class);
    private final MemcachedClientHolder clientHolder;

    protected BaseMemcachedClientManager(MemcachedClientHolder spyMemcachedClientHolder) {
        this.clientHolder = spyMemcachedClientHolder;
    }

    protected abstract DatarouterMemcachedClient buildClient(ClientId var1);

    protected void safeInitClient(ClientId clientId) {
        logger.info("{} activating client={}", (Object)((Object)((Object)this)).getClass().getSimpleName(), (Object)clientId.getName());
        PhaseTimer timer = new PhaseTimer(clientId.getName());
        System.setProperty("net.spy.log.LoggerImpl", SLF4JLogger.class.getName());
        this.clientHolder.register(clientId, this.buildClient(clientId));
        logger.warn(timer.add("done").toString());
    }

    public void shutdown(ClientId clientId) {
        this.clientHolder.get(clientId).getSpyClient().shutdown();
    }

    public DatarouterMemcachedClient getClient(ClientId clientId) {
        this.initClient(clientId);
        return this.clientHolder.get(clientId);
    }

    public Supplier<DatarouterMemcachedClient> getLazyClient(ClientId clientId) {
        return SingletonSupplier.of(() -> this.getClient(clientId));
    }
}

