/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.memcached.util;

import io.datarouter.scanner.Scanner;
import io.datarouter.storage.node.NodeParams;
import io.datarouter.storage.serialize.fieldcache.PhysicalDatabeanFieldInfo;
import io.datarouter.storage.util.Subpath;
import io.datarouter.util.HashMethods;
import io.datarouter.util.Require;
import io.datarouter.util.string.StringTool;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabeanNodePrefix {
    private static final Logger logger = LoggerFactory.getLogger(DatabeanNodePrefix.class);
    private final Subpath prefix;
    private final String codecVersion;
    private final String serviceName;
    private final String clientVersion;
    private final NodeParams<?, ?, ?> params;
    private final PhysicalDatabeanFieldInfo<?, ?, ?> fieldInfo;

    public DatabeanNodePrefix(Subpath prefix, String codecVersion, String serviceName, String clientVersion, NodeParams<?, ?, ?> params, PhysicalDatabeanFieldInfo<?, ?, ?> fieldInfo) {
        this.prefix = prefix;
        this.codecVersion = codecVersion;
        this.serviceName = serviceName;
        this.clientVersion = clientVersion;
        this.params = params;
        this.fieldInfo = fieldInfo;
    }

    public Subpath makeSubpath() {
        return this.prefix.append(this.makeFullSuffix());
    }

    public Subpath makeShortenedSubpath() {
        return this.prefix.append(this.makeShortenedSuffix());
    }

    private Subpath makeFullSuffix() {
        return (Subpath)Scanner.of((Object[])new String[]{this.codecVersion, this.serviceName, this.params.getClientId().getName(), this.clientVersion, this.fieldInfo.getTableName(), this.makeNodeVersion(), this.makeDatabeanVersion()}).exclude(StringTool::isEmpty).listTo(Subpath::new);
    }

    private Subpath makeShortenedSuffix() {
        String fullSuffix = this.makeFullSuffix().toString();
        Require.isTrue((boolean)fullSuffix.endsWith("/"));
        String hashInput = fullSuffix.substring(0, fullSuffix.length() - 1);
        String shortenedSuffix = Long.toString(HashMethods.longDjbHash((String)hashInput));
        logger.warn("shortening suffix {} to {}", (Object)fullSuffix, (Object)shortenedSuffix);
        return new Subpath(new String[]{shortenedSuffix});
    }

    private String makeNodeVersion() {
        return Optional.ofNullable(this.params.getSchemaVersion()).map(Object::toString).orElse("");
    }

    private String makeDatabeanVersion() {
        String schema = String.join((CharSequence)",", this.fieldInfo.getFieldColumnNames());
        long longVersion = HashMethods.longDjbHash((String)schema);
        return Long.toString(longVersion);
    }
}

