/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.memcached.node;

import io.datarouter.client.memcached.client.DatarouterMemcachedClient;
import io.datarouter.client.memcached.codec.MemcachedTallyCodec;
import io.datarouter.client.memcached.util.MemcachedExpirationTool;
import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.scanner.OptionalScanner;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.client.ClientType;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.node.NodeParams;
import io.datarouter.storage.node.op.raw.TallyStorage;
import io.datarouter.storage.node.type.physical.base.BasePhysicalNode;
import io.datarouter.util.tuple.Pair;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;

public class MemcachedTallyNode<PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>>
extends BasePhysicalNode<PK, D, F>
implements TallyStorage.PhysicalTallyStorageNode<PK, D, F> {
    public static final String CODEC_VERSION = "1";
    private static final Boolean DEFAULT_IGNORE_EXCEPTION = true;
    private final Supplier<DatarouterMemcachedClient> lazyClient;
    private final MemcachedTallyCodec tallyCodec;

    public MemcachedTallyNode(NodeParams<PK, D, F> params, ClientType<?, ?> clientType, MemcachedTallyCodec tallyCodec, Supplier<DatarouterMemcachedClient> lazyClient) {
        super(params, clientType);
        this.tallyCodec = tallyCodec;
        this.lazyClient = lazyClient;
    }

    public Long incrementAndGetCount(String tallyStringKey, int delta, Config config) {
        return this.tallyCodec.encodeKeyIfValid(tallyStringKey).map(encodedKey -> this.lazyClient.get().increment((String)encodedKey, delta, MemcachedExpirationTool.getExpirationSeconds(config), config.ignoreExceptionOrUse(DEFAULT_IGNORE_EXCEPTION))).orElse(0L);
    }

    public Optional<Long> findTallyCount(String key, Config config) {
        return Optional.ofNullable(this.getMultiTallyCount(List.of(key), config).get(key));
    }

    public Map<String, Long> getMultiTallyCount(Collection<String> tallyStringKeys, Config config) {
        return ((Scanner)Scanner.of(tallyStringKeys).map(this.tallyCodec::encodeKeyIfValid).concat(OptionalScanner::of).listTo(memcachedStringKeys -> this.lazyClient.get().scanMultiStrings(this.getName(), (Collection<String>)memcachedStringKeys, config.getTimeout().toMillis(), config.ignoreExceptionOrUse(DEFAULT_IGNORE_EXCEPTION)))).map(this.tallyCodec::decodeResult).toMap(Pair::getLeft, Pair::getRight);
    }

    public void deleteTally(String tallyStringKey, Config config) {
        this.tallyCodec.encodeKeyIfValid(tallyStringKey).ifPresent(memcachedStringKey -> this.lazyClient.get().deleteTally(this.getName(), (String)memcachedStringKey, config.getTimeout(), config.ignoreExceptionOrUse(DEFAULT_IGNORE_EXCEPTION)));
    }
}

