/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.memcached.node;

import io.datarouter.client.memcached.codec.MemcachedDatabeanCodec;
import io.datarouter.client.memcached.node.MemcachedBlobNode;
import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.scanner.OptionalScanner;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.client.ClientType;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.file.PathbeanKey;
import io.datarouter.storage.node.NodeParams;
import io.datarouter.storage.node.op.raw.MapStorage;
import io.datarouter.storage.node.type.physical.base.BasePhysicalNode;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class MemcachedDatabeanNode<PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>>
extends BasePhysicalNode<PK, D, F>
implements MapStorage.PhysicalMapStorageNode<PK, D, F> {
    public static final String CODEC_VERSION = "1";
    private final MemcachedBlobNode blobNode;
    private final MemcachedDatabeanCodec<PK, D, F> databeanCodec;

    public MemcachedDatabeanNode(NodeParams<PK, D, F> params, ClientType<?, ?> clientType, MemcachedBlobNode blobNode, MemcachedDatabeanCodec<PK, D, F> databeanCodec) {
        super(params, clientType);
        this.blobNode = blobNode;
        this.databeanCodec = databeanCodec;
    }

    public boolean exists(PK key, Config config) {
        return this.databeanCodec.encodeKeyIfValid((PrimaryKey<?>)key).map(this.blobNode::exists).orElse(false);
    }

    public List<PK> getKeys(Collection<PK> keys, Config config) {
        return this.scanMultiInternal(keys).map(Databean::getKey).list();
    }

    public D get(PK key, Config config) {
        return (D)((Databean)this.scanMultiInternal(List.of(key)).findFirst().orElse(null));
    }

    public List<D> getMulti(Collection<PK> keys, Config config) {
        return this.scanMultiInternal(keys).list();
    }

    public void delete(PK key, Config config) {
        this.deleteMulti(List.of(key), config);
    }

    public void deleteMulti(Collection<PK> keys, Config config) {
        Scanner.of(keys).map(this.databeanCodec::encodeKeyIfValid).concat(OptionalScanner::of).forEach(this.blobNode::delete);
    }

    public void deleteAll(Config config) {
        throw new UnsupportedOperationException();
    }

    public void put(D databean, Config config) {
        this.putMulti(List.of(databean), config);
    }

    public void putMulti(Collection<D> databeans, Config config) {
        Scanner.of(databeans).map(this.databeanCodec::encodeDatabeanIfValid).concat(OptionalScanner::of).forEach(keyAndValue -> this.blobNode.write((PathbeanKey)keyAndValue.getLeft(), (byte[])keyAndValue.getRight(), config));
    }

    private Scanner<D> scanMultiInternal(Collection<PK> keys) {
        Map bytesByKey = (Map)Scanner.of(keys).map(this.databeanCodec::encodeKeyIfValid).concat(OptionalScanner::of).listTo(this.blobNode::read);
        return Scanner.of(bytesByKey.values()).map(this.databeanCodec::decodeDatabean);
    }
}

