/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.memcached.codec;

import io.datarouter.model.databean.Databean;
import io.datarouter.model.databean.DatabeanTool;
import io.datarouter.model.field.Field;
import io.datarouter.model.field.FieldSetTool;
import io.datarouter.model.field.FieldTool;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.storage.file.PathbeanKey;
import io.datarouter.util.tuple.Pair;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemcachedDatabeanCodec<PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>> {
    private static final Logger logger = LoggerFactory.getLogger(MemcachedDatabeanCodec.class);
    private final String clientTypeName;
    private final DatabeanFielder<PK, D> fielder;
    private final Supplier<D> databeanSupplier;
    private final Map<String, Field<?>> fieldByPrefixedName;
    private final int clientMaxValueLength;
    private final int nodeSubpathLength;
    private final int maxKeyLength;

    public MemcachedDatabeanCodec(String clientTypeName, DatabeanFielder<PK, D> fielder, Supplier<D> databeanSupplier, Map<String, Field<?>> fieldByPrefixedName, int clientMaxKeyLength, int clientMaxValueLength, int nodeSubpathLength) {
        this.clientTypeName = clientTypeName;
        this.fielder = fielder;
        this.databeanSupplier = databeanSupplier;
        this.fieldByPrefixedName = fieldByPrefixedName;
        this.clientMaxValueLength = clientMaxValueLength;
        this.nodeSubpathLength = nodeSubpathLength;
        this.maxKeyLength = clientMaxKeyLength - nodeSubpathLength;
    }

    public Optional<Pair<PathbeanKey, byte[]>> encodeDatabeanIfValid(D databean) {
        Optional<PathbeanKey> pathbeanKey = this.encodeKeyIfValid(databean.getKey());
        if (pathbeanKey.isEmpty()) {
            return Optional.empty();
        }
        byte[] value = this.encodeDatabean(databean);
        if (value.length > this.clientMaxValueLength) {
            logger.warn("object too big for {} length={} key={}", new Object[]{this.clientTypeName, value.length, databean.getKey()});
            return Optional.empty();
        }
        return Optional.of(new Pair((Object)pathbeanKey.orElseThrow(), (Object)value));
    }

    public Optional<PathbeanKey> encodeKeyIfValid(PrimaryKey<?> pk) {
        PathbeanKey pathbeanKey = MemcachedDatabeanCodec.encodeDatabeanKey(pk);
        String encodedKey = pathbeanKey.getPathAndFile();
        if (pathbeanKey.getPathAndFile().length() > this.maxKeyLength) {
            logger.warn("key too long for {} length={} nodeSubpathLength={} maxKeyLength={} key={} encodedKey={}", new Object[]{this.clientTypeName, encodedKey.length(), this.nodeSubpathLength, this.maxKeyLength, pk, encodedKey});
            return Optional.empty();
        }
        return Optional.of(pathbeanKey);
    }

    private byte[] encodeDatabean(D databean) {
        return DatabeanTool.getBytes(databean, this.fielder);
    }

    public D decodeDatabean(byte[] bytes) {
        return (D)((Databean)FieldSetTool.fieldSetFromBytes(this.databeanSupplier, this.fieldByPrefixedName, (byte[])bytes));
    }

    private static PathbeanKey encodeDatabeanKey(PrimaryKey<?> pk) {
        byte[] bytes = FieldTool.getConcatenatedValueBytes((List)pk.getFields());
        String string = Base64.getUrlEncoder().encodeToString(bytes);
        return PathbeanKey.of((String)string);
    }
}

