/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.memcached.client;

import io.datarouter.client.memcached.client.SpyMemcachedClient;
import io.datarouter.instrumentation.trace.TraceSpanFinisher;
import io.datarouter.instrumentation.trace.TraceSpanGroupType;
import io.datarouter.instrumentation.trace.TracerTool;
import io.datarouter.scanner.Scanner;
import io.datarouter.util.tuple.Pair;
import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatarouterMemcachedClient {
    private static final Logger logger = LoggerFactory.getLogger(DatarouterMemcachedClient.class);
    private final SpyMemcachedClient spyClient;

    public DatarouterMemcachedClient(SpyMemcachedClient spyClient) {
        this.spyClient = spyClient;
    }

    public SpyMemcachedClient getSpyClient() {
        return this.spyClient;
    }

    public Scanner<Pair<String, byte[]>> scanMultiBytes(String nodeName, Collection<String> keys, long timeoutMs, boolean ignoreExceptions) {
        return this.scanMulti(nodeName, keys, byte[].class, timeoutMs, ignoreExceptions);
    }

    public Scanner<Pair<String, String>> scanMultiStrings(String nodeName, Collection<String> keys, long timeoutMs, boolean ignoreExceptions) {
        return this.scanMulti(nodeName, keys, String.class, timeoutMs, ignoreExceptions);
    }

    private <T> Scanner<Pair<String, T>> scanMulti(String nodeName, Collection<String> keys, Class<T> castValuesTo, long timeoutMs, boolean ignoreExceptions) {
        if (keys.isEmpty()) {
            return Scanner.empty();
        }
        long start = System.currentTimeMillis();
        Throwable throwable = null;
        Object var10_9 = null;
        try (TraceSpanFinisher $ = TracerTool.startSpan((String)(String.valueOf(nodeName) + " get bulk"), (TraceSpanGroupType)TraceSpanGroupType.DATABASE);){
            Map results = (Map)this.spyClient.asyncGetBulk(keys).get(timeoutMs, TimeUnit.MILLISECONDS);
            TracerTool.appendToSpanInfo((TracerTool.TraceSpanInfoBuilder)new TracerTool.TraceSpanInfoBuilder().add("keys", (Object)keys.size()).add("results", (Object)results.size()));
            return Scanner.of(results.entrySet()).map(entry -> new Pair((Object)((String)entry.getKey()), castValuesTo.cast(entry.getValue())));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void set(String nodeName, String key, int expiration, byte[] bytes) {
        Throwable throwable = null;
        Object var6_7 = null;
        try (TraceSpanFinisher $ = TracerTool.startSpan((String)(String.valueOf(nodeName) + " " + "set"), (TraceSpanGroupType)TraceSpanGroupType.DATABASE);){
            TracerTool.appendToSpanInfo((String)"bytes", (Object)bytes.length);
            try {
                this.spyClient.set(key, expiration, bytes);
            }
            catch (Exception e) {
                String message = String.format("error incrementing key=%s", key);
                throw new RuntimeException(message, e);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public Long increment(String key, int delta, int expiration, boolean ignoreException) {
        try {
            return this.spyClient.incr(key, delta, delta, expiration);
        }
        catch (Exception e) {
            String message = String.format("error incrementing key=%s", key);
            if (ignoreException) {
                logger.warn(message, (Throwable)e);
                return null;
            }
            throw new RuntimeException(message, e);
        }
    }

    public void delete(String nodeName, String key, Duration timeout) {
        Throwable throwable = null;
        Object var5_6 = null;
        try (TraceSpanFinisher $ = TracerTool.startSpan((String)(String.valueOf(nodeName) + " " + "delete"), (TraceSpanGroupType)TraceSpanGroupType.DATABASE);){
            long start = System.currentTimeMillis();
            try {
                this.spyClient.delete(key).get(timeout.toMillis(), TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                TracerTool.appendToSpanInfo((String)"memcached timeout");
                long elapsedMs = System.currentTimeMillis() - start;
                String details = "timeout after " + elapsedMs + "ms";
                throw new RuntimeException(details, e);
            }
            catch (Exception e) {
                TracerTool.appendToSpanInfo((String)"memcached exception");
                String message = String.format("error deleting key=%s", key);
                throw new RuntimeException(message, e);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void deleteTally(String nodeName, String key, Duration timeout, boolean ignoreException) {
        try {
            this.delete(nodeName, key, timeout);
        }
        catch (Exception exception) {
            if (ignoreException) {
                logger.error("memcached error on " + key, (Throwable)exception);
            }
            throw exception;
        }
    }
}

