/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.memcached.client;

import io.datarouter.bytes.ByteUnitType;
import io.datarouter.client.memcached.ReservedBlobPaths;
import io.datarouter.client.memcached.client.BaseMemcachedClientManager;
import io.datarouter.client.memcached.codec.MemcachedBlobCodec;
import io.datarouter.client.memcached.codec.MemcachedDatabeanCodec;
import io.datarouter.client.memcached.codec.MemcachedTallyCodec;
import io.datarouter.client.memcached.node.MemcachedBlobNode;
import io.datarouter.client.memcached.node.MemcachedDatabeanNode;
import io.datarouter.client.memcached.node.MemcachedTallyNode;
import io.datarouter.client.memcached.util.DatabeanNodePrefix;
import io.datarouter.model.databean.Databean;
import io.datarouter.model.entity.Entity;
import io.datarouter.model.key.entity.EntityKey;
import io.datarouter.model.key.primary.EntityPrimaryKey;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.storage.client.ClientType;
import io.datarouter.storage.client.imp.BlobClientNodeFactory;
import io.datarouter.storage.client.imp.DatabeanClientNodeFactory;
import io.datarouter.storage.client.imp.TallyClientNodeFactory;
import io.datarouter.storage.file.Pathbean;
import io.datarouter.storage.file.PathbeanKey;
import io.datarouter.storage.node.NodeParams;
import io.datarouter.storage.node.adapter.NodeAdapters;
import io.datarouter.storage.node.entity.EntityNodeParams;
import io.datarouter.storage.node.op.raw.BlobStorage;
import io.datarouter.storage.node.type.physical.PhysicalNode;
import io.datarouter.storage.serialize.fieldcache.PhysicalDatabeanFieldInfo;
import io.datarouter.storage.util.Subpath;
import io.datarouter.web.config.service.ServiceName;
import javax.inject.Singleton;

@Singleton
public class BaseMemcachedClientNodeFactory
implements BlobClientNodeFactory,
DatabeanClientNodeFactory,
TallyClientNodeFactory {
    private final ClientType<?, ?> memcachedClientType;
    private final ServiceName serviceName;
    private final BaseMemcachedClientManager memcachedClientManager;
    private final NodeAdapters nodeAdapters;

    public BaseMemcachedClientNodeFactory(ClientType<?, ?> memcachedClientType, ServiceName serviceName, BaseMemcachedClientManager memcachedClientManager, NodeAdapters nodeAdapters) {
        this.memcachedClientType = memcachedClientType;
        this.serviceName = serviceName;
        this.memcachedClientManager = memcachedClientManager;
        this.nodeAdapters = nodeAdapters;
    }

    public BlobStorage.PhysicalBlobStorageNode createBlobNode(NodeParams<PathbeanKey, Pathbean, Pathbean.PathbeanFielder> nodeParams) {
        MemcachedBlobNode node = new MemcachedBlobNode(nodeParams, this.memcachedClientType, new MemcachedBlobCodec(nodeParams.getPath()), this.memcachedClientManager.getLazyClient(nodeParams.getClientId()));
        return this.nodeAdapters.wrapBlobNode((BlobStorage.PhysicalBlobStorageNode)node);
    }

    public <EK extends EntityKey<EK>, E extends Entity<EK>, PK extends EntityPrimaryKey<EK, PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>> PhysicalNode<PK, D, F> createDatabeanNode(EntityNodeParams<EK, E> entityNodeParams, NodeParams<PK, D, F> nodeParams) {
        PhysicalDatabeanFieldInfo fieldInfo = new PhysicalDatabeanFieldInfo(nodeParams);
        Subpath path = new DatabeanNodePrefix(ReservedBlobPaths.DATABEAN, "1", this.serviceName.get(), "1", nodeParams, fieldInfo).makeShortenedSubpath();
        NodeParams blobParams = new NodeParams.NodeParamsBuilder(nodeParams).withPath(path).build();
        MemcachedBlobNode blobNode = new MemcachedBlobNode(this.toPathbeanParams(blobParams), this.memcachedClientType, new MemcachedBlobCodec(path), this.memcachedClientManager.getLazyClient(nodeParams.getClientId()));
        MemcachedDatabeanCodec databeanCodec = new MemcachedDatabeanCodec(this.memcachedClientType.getName(), fieldInfo.getSampleFielder(), fieldInfo.getDatabeanSupplier(), fieldInfo.getFieldByPrefixedName(), 250, ByteUnitType.MiB.toBytesInt(2L), path.toString().length());
        MemcachedDatabeanNode<PK, D, F> node = new MemcachedDatabeanNode<PK, D, F>(nodeParams, this.memcachedClientType, blobNode, databeanCodec);
        return this.nodeAdapters.wrapDatabeanMapNode(node);
    }

    private NodeParams<PathbeanKey, Pathbean, Pathbean.PathbeanFielder> toPathbeanParams(NodeParams<?, ?, ?> params) {
        return params;
    }

    public <PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>> PhysicalNode<PK, D, F> createTallyNode(NodeParams<PK, D, F> nodeParams) {
        PhysicalDatabeanFieldInfo fieldInfo = new PhysicalDatabeanFieldInfo(nodeParams);
        Subpath path = new DatabeanNodePrefix(ReservedBlobPaths.TALLY, "1", this.serviceName.get(), "1", nodeParams, fieldInfo).makeShortenedSubpath();
        MemcachedTallyCodec tallyCodec = new MemcachedTallyCodec(this.memcachedClientType.getName(), path, 250);
        MemcachedTallyNode<PK, D, F> node = new MemcachedTallyNode<PK, D, F>(nodeParams, this.memcachedClientType, tallyCodec, this.memcachedClientManager.getLazyClient(nodeParams.getClientId()));
        return this.nodeAdapters.wrapTallyNode(node);
    }
}

