/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.memcached.node;

import io.datarouter.bytes.ByteTool;
import io.datarouter.bytes.InputStreamTool;
import io.datarouter.client.memcached.client.MemcachedClientManager;
import io.datarouter.client.memcached.client.MemcachedOps;
import io.datarouter.client.memcached.codec.MemcachedBlobCodec;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.client.ClientType;
import io.datarouter.storage.file.Pathbean;
import io.datarouter.storage.file.PathbeanKey;
import io.datarouter.storage.node.NodeParams;
import io.datarouter.storage.node.op.raw.BlobStorage;
import io.datarouter.storage.node.type.physical.base.BasePhysicalNode;
import io.datarouter.storage.util.Subpath;
import io.datarouter.util.tuple.Pair;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class MemcachedBlobNode
extends BasePhysicalNode<PathbeanKey, Pathbean, Pathbean.PathbeanFielder>
implements BlobStorage.PhysicalBlobStorageNode {
    private static final Duration DEFAULT_TIMEOUT = Duration.ofSeconds(3L);
    private static final Boolean DEFAULT_IGNORE_EXCEPTION = true;
    private final ClientId clientId;
    private final String bucket;
    private final Subpath rootPath;
    private final Integer schemaVersion;
    private final MemcachedBlobCodec codec;
    private final MemcachedOps ops;

    public MemcachedBlobNode(NodeParams<PathbeanKey, Pathbean, Pathbean.PathbeanFielder> params, ClientType<?, ?> clientType, MemcachedClientManager memcachedClientManager) {
        super(params, clientType);
        this.clientId = params.getClientId();
        this.bucket = params.getPhysicalName();
        this.rootPath = params.getPath();
        this.schemaVersion = Optional.ofNullable(params.getSchemaVersion()).orElse(1);
        this.codec = new MemcachedBlobCodec(this.getName(), this.schemaVersion);
        this.ops = new MemcachedOps(memcachedClientManager);
    }

    public String getBucket() {
        return this.bucket;
    }

    public Subpath getRootPath() {
        return this.rootPath;
    }

    public boolean exists(PathbeanKey key) {
        return this.scanMultiInternal(List.of(key)).hasAny();
    }

    public Optional<Long> length(PathbeanKey key) {
        return this.scanMultiInternal(List.of(key)).map(Pair::getRight).map(bytes -> ((byte[])bytes).length).map(Integer::longValue).findFirst();
    }

    public byte[] read(PathbeanKey key) {
        return this.scanMultiInternal(List.of(key)).findFirst().map(Pair::getRight).orElse(null);
    }

    public Map<PathbeanKey, byte[]> read(List<PathbeanKey> keys) {
        return this.scanMultiInternal(keys).toMap(Pair::getLeft, Pair::getRight);
    }

    public byte[] read(PathbeanKey key, long offset, int length) {
        return this.scanMultiInternal(List.of(key)).findFirst().map(Pair::getRight).map(bytes -> ByteTool.copyOfRange((byte[])bytes, (int)((int)offset), (int)length)).orElse(null);
    }

    public Scanner<List<PathbeanKey>> scanKeysPaged(Subpath subpath) {
        throw new UnsupportedOperationException();
    }

    public Scanner<List<Pathbean>> scanPaged(Subpath subpath) {
        throw new UnsupportedOperationException();
    }

    public void write(PathbeanKey key, byte[] value) {
        this.ops.set(this.clientId, this.getName(), this.codec.encodeKey(key), Integer.MAX_VALUE, value);
    }

    public void write(PathbeanKey key, Scanner<byte[]> chunks) {
        byte[] bytes = (byte[])chunks.listTo(ByteTool::concat);
        this.write(key, bytes);
    }

    public void write(PathbeanKey key, InputStream inputStream) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        InputStreamTool.transferTo((InputStream)inputStream, (OutputStream)baos);
        this.write(key, baos.toByteArray());
    }

    public void delete(PathbeanKey key) {
        this.ops.delete(this.clientId, this.getName(), this.codec.encodeKey(key), Duration.ofSeconds(3L));
    }

    public void deleteAll(Subpath subpath) {
        throw new UnsupportedOperationException();
    }

    private Scanner<Pair<PathbeanKey, byte[]>> scanMultiInternal(Collection<PathbeanKey> keys) {
        return ((Scanner)Scanner.of(keys).map(this.codec::encodeKey).listTo(memcachedStringKeys -> this.ops.fetch(this.clientId, this.getName(), (Collection<String>)memcachedStringKeys, DEFAULT_TIMEOUT.toMillis(), DEFAULT_IGNORE_EXCEPTION))).map(this.codec::decodeResult);
    }
}

