/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.memcached.codec;

import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.storage.file.PathbeanKey;
import io.datarouter.storage.util.PrimaryKeyPercentCodecTool;
import io.datarouter.util.HashMethods;
import io.datarouter.util.lang.ReflectionTool;
import java.util.function.Supplier;

public class MemcachedKey<PK extends PrimaryKey<PK>> {
    public static final int CODEC_VERSION = 3;
    private static final int NUM_TOKENS = 4;
    public final int codecVersion;
    public final String nodeName;
    public final int schemaVersion;
    public final PK primaryKey;

    public MemcachedKey(int codecVersion, String nodeName, int schemaVersion, PK primaryKey) {
        this.codecVersion = codecVersion;
        this.nodeName = nodeName;
        this.schemaVersion = schemaVersion;
        this.primaryKey = primaryKey;
    }

    public static String encode(String nodeName, int schemaVersion, PrimaryKey<?> pk) {
        String encodedPk = PrimaryKeyPercentCodecTool.encode(pk);
        return "3:" + nodeName + ":" + schemaVersion + ":" + encodedPk;
    }

    public static PathbeanKey encodeKeyToPathbeanKey(String serviceName, String clientName, String tableName, int schemaVersion, Long autoSchemaVersion, PrimaryKey<?> pk) {
        String encodedPk = PrimaryKeyPercentCodecTool.encode(pk);
        String keyMetadata = "3/" + serviceName + "/" + clientName + "/" + tableName + "/" + schemaVersion + "/" + autoSchemaVersion + "/";
        Long keyMetadataHashed = HashMethods.longDjbHash((String)keyMetadata);
        return PathbeanKey.of((String)(String.valueOf(String.valueOf(keyMetadataHashed)) + "/" + encodedPk));
    }

    public static <PK extends PrimaryKey<PK>> MemcachedKey<PK> decode(String stringKey, Class<PK> pkClass) {
        String[] tokens = stringKey.split(":");
        if (tokens.length != 4) {
            String message = String.format("Incorrect number of key parts.  Expected=%s, found=%s, input=%s", 4, tokens.length, stringKey);
            throw new RuntimeException(message);
        }
        int codecVersion = Integer.parseInt(tokens[0]);
        String nodeName = tokens[1];
        int schemaVersion = Integer.parseInt(tokens[2]);
        PrimaryKey primaryKey = PrimaryKeyPercentCodecTool.decode((Supplier)ReflectionTool.supplier(pkClass), (String)tokens[3]);
        return new MemcachedKey<PrimaryKey>(codecVersion, nodeName, schemaVersion, primaryKey);
    }
}

