/**
 * Copyright © 2009 HotPads (admin@hotpads.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.datarouter.instrumentation.trace;

public class TraceDto{

	private String traceId;
	private String context;
	private String type;
	private String params;
	private Long created;
	private Long duration;
	private Integer discardedThreadCount;

	public TraceDto(String traceId, Long created){
		this.traceId = traceId;
		this.created = created;
	}

	public TraceDto(
			String traceId,
			String context,
			String type,
			String params,
			Long created,
			Long duration,
			Integer discardedThreadCount){
		this(traceId, created);
		this.context = context;
		this.type = type;
		this.params = params;
		this.duration = duration;
		this.discardedThreadCount = discardedThreadCount;
	}

	public void markFinished(){
		duration = System.currentTimeMillis() - created;
	}

	public String getTraceId(){
		return traceId;
	}

	public void setTraceId(String traceId){
		this.traceId = traceId;
	}

	public String getContext(){
		return context;
	}

	public void setContext(String context){
		this.context = context;
	}

	public String getType(){
		return type;
	}

	public void setType(String type){
		this.type = type;
	}

	public String getParams(){
		return params;
	}

	public void setParams(String params){
		this.params = params;
	}

	public Long getCreated(){
		return created;
	}

	public void setCreated(Long created){
		this.created = created;
	}

	public Long getDuration(){
		return duration;
	}

	public void setDuration(Long duration){
		this.duration = duration;
	}

	public void setDiscardedThreadCount(Integer discardedThreadCount){
		this.discardedThreadCount = discardedThreadCount;
	}

	public Integer getDiscardedThreadCount(){
		return discardedThreadCount;
	}

}
