/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.gcp.bigtable.client;

import io.datarouter.client.hbase.client.HBaseOptions;
import io.datarouter.secret.op.SecretOpReason;
import io.datarouter.secret.service.SecretService;
import io.datarouter.storage.client.ClientOptions;
import io.datarouter.util.SystemTool;
import io.datarouter.util.lang.ObjectTool;
import io.datarouter.util.tuple.Twin;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class BigTableOptions
extends HBaseOptions {
    private static final Logger logger = LoggerFactory.getLogger(BigTableOptions.class);
    private static final String PREFIX_bigtable = "bigtable.";
    protected static final String PROP_projectId = "projectId";
    protected static final String PROP_instanceId = "instanceId";
    protected static final String PROP_credentialsFileLocation = "credentialsFileLocation";
    protected static final String PROP_credentialsSecretLocation = "credentialsSecretLocation";
    @Inject
    private ClientOptions clientOptions;
    @Inject
    private SecretService secretService;

    public String projectId(String clientName) {
        return this.clientOptions.getRequiredString(clientName, BigTableOptions.makeBigtableKey(PROP_projectId));
    }

    public String instanceId(String clientName) {
        return this.clientOptions.getRequiredString(clientName, BigTableOptions.makeBigtableKey(PROP_instanceId));
    }

    public String findProjectId(String clientName) {
        return this.clientOptions.optString(clientName, BigTableOptions.makeBigtableKey(PROP_projectId)).orElse("");
    }

    public String findInstanceId(String clientName) {
        return this.clientOptions.optString(clientName, BigTableOptions.makeBigtableKey(PROP_instanceId)).orElse("");
    }

    public Twin<String> bigtableConfigurationCredentialsKeyValue(String clientName) {
        return this.readCredentialsSecretKeyValue(clientName).or(() -> this.readCredentialsFileKeyValue(clientName)).orElseThrow(() -> new RuntimeException("no bigtable credentials configuration found"));
    }

    public Optional<Twin<String>> readCredentialsFileKeyValue(String clientName) {
        Optional optProvided = this.clientOptions.optString(clientName, BigTableOptions.makeBigtableKey(PROP_credentialsFileLocation));
        if (optProvided.isEmpty()) {
            logger.warn("{} not specified", (Object)PROP_credentialsFileLocation);
            return Optional.empty();
        }
        return optProvided.map(provided -> {
            String corrected = provided.replace("~", SystemTool.getUserHome());
            if (ObjectTool.notEquals((Object)provided, (Object)corrected)) {
                logger.warn("updated credentialsLocation from {} to {}", provided, (Object)corrected);
            }
            return corrected;
        }).map($ -> new Twin((Object)"google.bigtable.auth.json.keyfile", $));
    }

    public Optional<Twin<String>> readCredentialsSecretKeyValue(String clientName) {
        Optional optSecretLocation = this.clientOptions.optString(clientName, BigTableOptions.makeBigtableKey(PROP_credentialsSecretLocation));
        if (optSecretLocation.isEmpty()) {
            logger.warn("{} not specified", (Object)PROP_credentialsSecretLocation);
            return Optional.empty();
        }
        return optSecretLocation.map($ -> this.secretService.readRawSharedWithoutRecord($, SecretOpReason.automatedOp((String)((Object)((Object)this)).getClass().getSimpleName()))).map($ -> new Twin((Object)"google.bigtable.auth.json.value", $));
    }

    protected static String makeBigtableKey(String propertyKey) {
        return PREFIX_bigtable + propertyKey;
    }
}

