/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.gcp.bigtable.client;

import io.datarouter.client.hbase.client.HBaseOptions;
import io.datarouter.storage.client.ClientOptions;
import io.datarouter.util.SystemTool;
import io.datarouter.util.lang.ObjectTool;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class BigTableOptions
extends HBaseOptions {
    private static final Logger logger = LoggerFactory.getLogger(BigTableOptions.class);
    private static final String PREFIX_bigtable = "bigtable.";
    protected static final String PROP_projectId = "projectId";
    protected static final String PROP_instanceId = "instanceId";
    protected static final String PROP_credentialsLocation = "credentialsLocation";
    @Inject
    private ClientOptions clientOptions;

    public String projectId(String clientName) {
        return this.clientOptions.getRequiredString(clientName, BigTableOptions.makeBigtableKey(PROP_projectId));
    }

    public String instanceId(String clientName) {
        return this.clientOptions.getRequiredString(clientName, BigTableOptions.makeBigtableKey(PROP_instanceId));
    }

    public String findProjectId(String clientName) {
        return this.clientOptions.optString(clientName, BigTableOptions.makeBigtableKey(PROP_projectId)).orElse("");
    }

    public String findInstanceId(String clientName) {
        return this.clientOptions.optString(clientName, BigTableOptions.makeBigtableKey(PROP_instanceId)).orElse("");
    }

    public String credentialsLocation(String clientName) {
        String corrected;
        String provided = this.clientOptions.getRequiredString(clientName, BigTableOptions.makeBigtableKey(PROP_credentialsLocation));
        if (ObjectTool.notEquals((Object)provided, (Object)(corrected = provided.replace("~", SystemTool.getUserHome())))) {
            logger.warn("updated credentialsLocation from {} to {}", (Object)provided, (Object)corrected);
        }
        return corrected;
    }

    protected static String makeBigtableKey(String propertyKey) {
        return PREFIX_bigtable + propertyKey;
    }
}

