/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.gcp.bigtable.client;

import com.google.cloud.bigtable.hbase.BigtableConfiguration;
import io.datarouter.client.hbase.HBaseClientManager;
import io.datarouter.gcp.bigtable.client.BigTableOptions;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Connection;

@Singleton
public class BigTableClientManager
extends HBaseClientManager {
    @Inject
    private BigTableOptions bigTableOptions;

    public boolean monitorLatency() {
        return false;
    }

    protected Connection makeConnection(String clientName) {
        String projectId = this.bigTableOptions.projectId(clientName);
        String instanceId = this.bigTableOptions.instanceId(clientName);
        Configuration config = BigtableConfiguration.configure((String)projectId, (String)instanceId);
        String credsLocation = this.bigTableOptions.credentialsLocation(clientName);
        config.set("google.bigtable.auth.json.keyfile", credsLocation);
        return BigtableConfiguration.connect((Configuration)config);
    }
}

