/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.gcp.bigtable.client;

import io.datarouter.client.hbase.client.HBaseClientOptionsBuilder;
import io.datarouter.gcp.bigtable.client.BigTableOptions;
import io.datarouter.storage.client.ClientId;
import java.util.Properties;

public class BigTableClientOptionsBuilder
extends HBaseClientOptionsBuilder {
    public BigTableClientOptionsBuilder(ClientId clientId) {
        super(clientId, "bigtable");
    }

    public BigTableClientOptionsBuilder withProjectId(String projectId) {
        String optionKeySuffix = BigTableOptions.makeBigtableKey("projectId");
        String optionKey = this.makeKey(optionKeySuffix);
        this.properties.setProperty(optionKey, projectId);
        return this;
    }

    public BigTableClientOptionsBuilder withInstanceId(String instanceId) {
        String optionKeySuffix = BigTableOptions.makeBigtableKey("instanceId");
        String optionKey = this.makeKey(optionKeySuffix);
        this.properties.setProperty(optionKey, instanceId);
        return this;
    }

    public BigTableClientOptionsBuilder withCredentialsLocation(String credentialsLocation) {
        String optionKeySuffix = BigTableOptions.makeBigtableKey("credentialsLocation");
        String optionKey = this.makeKey(optionKeySuffix);
        this.properties.setProperty(optionKey, credentialsLocation);
        return this;
    }

    public Properties build() {
        return this.properties;
    }
}

