/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.gcp.bigtable.config;

import io.datarouter.gcp.bigtable.config.BigtableProjectIdAndInstanceIdSupplier;
import io.datarouter.web.dispatcher.DispatchRule;
import io.datarouter.web.navigation.DatarouterNavBarCategory;
import io.datarouter.web.navigation.DynamicNavBarItem;
import io.datarouter.web.navigation.NavBarCategory;
import io.datarouter.web.navigation.NavBarItem;
import io.datarouter.web.user.role.DatarouterUserRole;
import io.datarouter.web.user.session.service.RoleEnum;
import javax.inject.Inject;

public class GcpBigTableNavBarItem
implements DynamicNavBarItem {
    @Inject
    private BigtableProjectIdAndInstanceIdSupplier supplier;

    public NavBarItem getNavBarItem() {
        String projectId = this.supplier.getBigtableProjectId();
        String instanceId = this.supplier.getBigtableInstanceId();
        String link = "https://console.cloud.google.com/bigtable/instances/" + instanceId + "/overview?project=" + projectId;
        return new NavBarItem.NavBarItemBuilder((NavBarCategory)DatarouterNavBarCategory.EXTERNAL, link, "GCP Bigtable").openInNewTab().setDispatchRule(new DispatchRule().allowRoles(new RoleEnum[]{DatarouterUserRole.DATAROUTER_MONITORING})).build();
    }

    public Boolean shouldDisplay() {
        String projectId = this.supplier.getBigtableProjectId();
        String instanceId = this.supplier.getBigtableInstanceId();
        if (!projectId.isEmpty() && !instanceId.isEmpty()) {
            return true;
        }
        return false;
    }

    public DynamicNavBarItem.DynamicNavBarItemType getType() {
        return DynamicNavBarItem.DynamicNavBarItemType.DATAROUTER;
    }
}

