/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.filesystem.raw.queue;

import io.datarouter.bytes.codec.stringcodec.StringCodec;
import io.datarouter.filesystem.raw.DirectoryManager;
import io.datarouter.filesystem.raw.queue.DirectoryQueueMessage;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.util.Subpath;
import io.datarouter.types.Ulid;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class DirectoryQueue {
    private static final String EXTENSION = ".txt";
    private final DirectoryManager directoryManager;
    private final Map<String, Instant> openFilenames;

    public DirectoryQueue(DirectoryManager directoryManager) {
        this.directoryManager = directoryManager;
        this.openFilenames = new ConcurrentHashMap<String, Instant>();
    }

    public String putMessage(byte[] message) {
        String id = new Ulid().value();
        this.directoryManager.write(DirectoryQueue.idToFilename(id), message);
        return id;
    }

    public String putMessage(String message) {
        String id = new Ulid().value();
        byte[] messageBytes = StringCodec.UTF_8.encode(message);
        this.directoryManager.write(DirectoryQueue.idToFilename(id), messageBytes);
        return id;
    }

    public DirectoryQueueMessage getMessage(String id) {
        byte[] content = this.directoryManager.read(DirectoryQueue.idToFilename(id)).orElse(null);
        return new DirectoryQueueMessage(id, content);
    }

    public synchronized Optional<DirectoryQueueMessage> peek() {
        this.timeoutOpenMessages();
        return this.directoryManager.scanChildren(Subpath.empty(), this.openFilenames.keySet(), 1, false).map(Path::getFileName).map(Path::toString).each(filename -> {
            Instant instant = this.openFilenames.put((String)filename, Instant.now());
        }).findFirst().map(filename -> {
            byte[] content = this.directoryManager.read((String)filename).orElse(null);
            return new DirectoryQueueMessage(DirectoryQueue.filenameToId(filename), content);
        });
    }

    public void ack(String id) {
        String filename = DirectoryQueue.idToFilename(id);
        this.directoryManager.delete(filename);
        this.openFilenames.remove(filename);
    }

    public long estNumMessages() {
        return this.directoryManager.scanDescendantsPaged(Subpath.empty(), false, false).concat(Scanner::of).count();
    }

    public long estNumOpenMessages() {
        return this.openFilenames.size();
    }

    public long estNumWaitingMessages() {
        return this.directoryManager.scanDescendantsPaged(Subpath.empty(), false, false).concat(Scanner::of).map(Path::getFileName).map(Path::toString).map(DirectoryQueue::filenameToId).exclude(this.openFilenames::containsKey).count();
    }

    void timeoutOpenMessages() {
        Instant cutoff = Instant.now().minus(Duration.ofMinutes(10L));
        List tooOld = Scanner.of(this.openFilenames.entrySet()).include(entry -> ((Instant)entry.getValue()).isBefore(cutoff)).map(Map.Entry::getKey).list();
        tooOld.forEach(this.openFilenames::remove);
    }

    private static String idToFilename(String id) {
        return id + EXTENSION;
    }

    private static String filenameToId(String filename) {
        return filename.substring(0, filename.length() - EXTENSION.length());
    }
}

