/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.filesystem.snapshot.block.root;

import io.datarouter.bytes.ByteWriter;
import io.datarouter.bytes.codec.bytestringcodec.CsvIntByteStringCodec;
import io.datarouter.filesystem.snapshot.encode.EncodedBlock;
import io.datarouter.filesystem.snapshot.encode.RootBlockEncoder;
import io.datarouter.filesystem.snapshot.encode.RootBlockFields;
import java.util.Arrays;
import java.util.SortedMap;
import java.util.TreeMap;

public class RootBlockV1Encoder
implements RootBlockEncoder {
    private RootBlockFields fields;
    private SortedMap<byte[], byte[]> dictionary;

    @Override
    public void set(RootBlockFields fields) {
        this.fields = fields;
        this.dictionary = new TreeMap<byte[], byte[]>((a, b) -> Arrays.compareUnsigned(a, b));
    }

    public void addDictionaryEntry(byte[] key, byte[] value) {
        byte[] previousKey = this.dictionary.put(key, value);
        if (previousKey != null) {
            throw new IllegalArgumentException("duplicate key [" + CsvIntByteStringCodec.INSTANCE.encode(key) + "]");
        }
    }

    @Override
    public EncodedBlock encode() {
        ByteWriter writer = new ByteWriter(256);
        writer.varUtf8(this.format());
        writer.booleanByte(this.fields.sorted);
        writer.varUtf8(this.fields.paths.format());
        writer.varUtf8(this.fields.formats.branchBlockFormat);
        writer.varUtf8(this.fields.formats.leafBlockFormat);
        writer.varUtf8(this.fields.formats.valueBlockFormat);
        writer.varUtf8(this.fields.compressors.branchBlockCompressor);
        writer.varUtf8(this.fields.compressors.leafBlockCompressor);
        writer.varUtf8(this.fields.compressors.valueBlockCompressor);
        writer.varInt(this.fields.bytesPerFile.branchBytesPerFile);
        writer.varInt(this.fields.bytesPerFile.leafBytesPerFile);
        writer.varInt(this.fields.bytesPerFile.valueBytesPerFile);
        writer.varInt(this.fields.blocksPerFile.branchBlocksPerFile);
        writer.varInt(this.fields.blocksPerFile.leafBlocksPerFile);
        writer.varInt(this.fields.blocksPerFile.valueBlocksPerFile);
        writer.varLong(this.fields.numEntries);
        writer.varInt(this.fields.numBranchLevels);
        Arrays.stream(this.fields.blockCounts.numBranchBlocksByLevel).forEach(arg_0 -> ((ByteWriter)writer).varInt(arg_0));
        writer.varInt(this.fields.blockCounts.numLeafBlocks);
        writer.varInt(this.fields.blockCounts.numValueBlocksByColumn.length);
        Arrays.stream(this.fields.blockCounts.numValueBlocksByColumn).forEach(arg_0 -> ((ByteWriter)writer).varInt(arg_0));
        writer.varLong(this.fields.byteCountsEncoded.numBranchBytesEncoded);
        writer.varLong(this.fields.byteCountsEncoded.numLeafBytesEncoded);
        writer.varLong(this.fields.byteCountsEncoded.numValueBytesEncoded);
        writer.varLong(this.fields.byteCountsCompressed.numBranchBytesCompressed);
        writer.varLong(this.fields.byteCountsCompressed.numLeafBytesCompressed);
        writer.varLong(this.fields.byteCountsCompressed.numValueBytesCompressed);
        writer.varLong(this.fields.timings.writeStartTimeMs);
        writer.varLong(this.fields.timings.writeDurationMs);
        writer.varInt(this.fields.blockEndings.rootBranchBlockLength);
        writer.varInt(this.dictionary.size());
        this.dictionary.forEach((key, value) -> {
            writer.varBytes(key);
            writer.varBytes(value);
        });
        return new EncodedBlock(writer.trimmedPages());
    }

    @Override
    public String format() {
        return "rootV1";
    }
}

