/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.email.html;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;

public class EmailDto {
    public final String subject;
    public final String content;
    public final String fromEmail;
    public final boolean fromAdmin;
    public final List<String> toEmails;
    public final boolean toAdmin;
    public final boolean toSubscribers;
    public final boolean html;

    public EmailDto(String subject, String content, String fromEmail, boolean fromAdmin, List<String> toEmails, boolean toAdmin, boolean toSubscribers, boolean html) {
        this.subject = subject;
        this.content = content;
        this.fromEmail = fromEmail;
        this.fromAdmin = fromAdmin;
        this.toEmails = toEmails;
        this.toAdmin = toAdmin;
        this.toSubscribers = toSubscribers;
        this.html = html;
    }

    public static class EmailDtoBuilder {
        private String subject;
        private String content;
        private String fromEmail = null;
        private boolean fromAdmin = false;
        private List<String> toEmails = new ArrayList<String>();
        private boolean toAdmin = false;
        private boolean toSubscribers = false;
        private boolean html;

        public EmailDtoBuilder withSubject(String subject) {
            this.subject = subject;
            return this;
        }

        public EmailDtoBuilder withContent(String content, boolean html) {
            this.content = content;
            this.html = html;
            return this;
        }

        public EmailDtoBuilder from(String fromEmail) {
            this.fromEmail = fromEmail;
            return this;
        }

        public EmailDtoBuilder from(String fromEmail, String fromEmailAlt, Supplier<Boolean> condition) {
            this.fromEmail = condition.get() != false ? fromEmail : fromEmailAlt;
            return this;
        }

        public EmailDtoBuilder fromAdmin() {
            this.fromEmail = null;
            this.fromAdmin = true;
            return this;
        }

        public EmailDtoBuilder fromAdmin(String fromEmailAlt, Supplier<Boolean> condition) {
            if (condition.get().booleanValue()) {
                this.fromEmail = null;
                this.fromAdmin = true;
            } else {
                this.fromEmail = fromEmailAlt;
            }
            return this;
        }

        public EmailDtoBuilder to(Collection<String> tos) {
            this.toEmails.addAll(tos);
            return this;
        }

        public EmailDtoBuilder to(String toEmail) {
            this.toEmails.add(toEmail);
            return this;
        }

        public EmailDtoBuilder to(String toEmail, Supplier<Boolean> condition) {
            if (condition.get().booleanValue()) {
                this.toEmails.add(toEmail);
            }
            return this;
        }

        public EmailDtoBuilder to(String toEmail, boolean condition) {
            return this.to(toEmail, () -> condition);
        }

        public EmailDtoBuilder to(Collection<String> toEmails, boolean condition) {
            if (condition) {
                toEmails.addAll(toEmails);
            }
            return this;
        }

        public EmailDtoBuilder to(String toEmail, String toEmailAlt, Supplier<Boolean> condition) {
            if (condition.get().booleanValue()) {
                this.toEmails.add(toEmail);
            } else {
                this.toEmails.add(toEmailAlt);
            }
            return this;
        }

        public EmailDtoBuilder toSubscribers() {
            this.toSubscribers = true;
            return this;
        }

        public EmailDtoBuilder toSubscribers(boolean condition) {
            if (condition) {
                this.toSubscribers = true;
            }
            return this;
        }

        public EmailDtoBuilder toAdmin() {
            this.toAdmin = true;
            return this;
        }

        public EmailDtoBuilder toAdmin(boolean condition) {
            if (condition) {
                this.toAdmin = true;
            }
            return this;
        }

        public EmailDto build() {
            return new EmailDto(this.subject, this.content, this.fromEmail, this.fromAdmin, this.toEmails, this.toAdmin, this.toSubscribers, this.html);
        }
    }
}

