/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.email.email;

import io.datarouter.pathnode.PathNode;
import java.net.URISyntaxException;
import java.util.LinkedHashMap;
import org.apache.http.client.utils.URIBuilder;

public class DatarouterEmailLinkBuilder {
    private String protocol;
    private String hostPort;
    private String contextPath;
    private String localPath;
    private String fragment;
    private LinkedHashMap<String, String> params = new LinkedHashMap();

    public DatarouterEmailLinkBuilder withProtocol(String hrefProtocol) {
        this.protocol = hrefProtocol;
        return this;
    }

    public DatarouterEmailLinkBuilder withHostPort(String hostPort) {
        this.hostPort = hostPort;
        return this;
    }

    public DatarouterEmailLinkBuilder withContextPath(String hrefContextPath) {
        this.contextPath = hrefContextPath;
        return this;
    }

    public DatarouterEmailLinkBuilder withLocalPath(String hrefLocalPath) {
        this.localPath = hrefLocalPath;
        return this;
    }

    public DatarouterEmailLinkBuilder withLocalPath(PathNode hrefLocalPathNode) {
        this.localPath = hrefLocalPathNode.toSlashedString();
        return this;
    }

    public DatarouterEmailLinkBuilder withParam(String key, String value) {
        this.params.put(key, value);
        return this;
    }

    public DatarouterEmailLinkBuilder withFragment(String fragment) {
        this.fragment = fragment;
        return this;
    }

    public String build() {
        URIBuilder builder = new URIBuilder();
        builder.setScheme(this.protocol);
        builder.setHost(this.hostPort);
        builder.setPath(String.valueOf(this.contextPath) + this.localPath);
        this.params.forEach((arg_0, arg_1) -> ((URIBuilder)builder).addParameter(arg_0, arg_1));
        builder.setFragment(this.fragment);
        try {
            return builder.build().toString();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

