/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.email.config;

import io.datarouter.secret.service.CachedSecretFactory;
import io.datarouter.storage.setting.SettingFinder;
import io.datarouter.storage.setting.SettingNode;
import io.datarouter.storage.setting.cached.CachedSetting;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class DatarouterEmailSettings
extends SettingNode {
    private static final String DEFAULT_SMTP_HOST = "127.0.0.1";
    private static final Integer DEFAULT_SMTP_PORT = 25;
    public final CachedSetting<String> smtpHost;
    public final CachedSetting<Integer> smtpPort;
    public final CachedSetting<String> smtpUsername;
    public final CachedSetting<String> smtpPasswordName;
    private final CachedSecretFactory.CachedSecret<String> smtpPassword;
    public final CachedSetting<Boolean> useRemoteSmtp;
    public final CachedSetting<Boolean> sendDatarouterEmails = this.registerBoolean("sendDatarouterEmails", true);
    public final CachedSetting<String> emailLinkHostPort;
    public final CachedSetting<Boolean> includeLogo;
    public final CachedSetting<String> logoImgSrc;

    @Inject
    public DatarouterEmailSettings(SettingFinder finder, CachedSecretFactory cachedSecretFactory) {
        super(finder, "datarouterEmail.email.");
        this.useRemoteSmtp = this.registerBoolean("useRemoteSmtp", false);
        this.smtpHost = this.registerString("smtpHost", DEFAULT_SMTP_HOST);
        this.smtpPort = this.registerInteger("smtpPort", DEFAULT_SMTP_PORT);
        this.smtpUsername = this.registerString("smtpUsername", "");
        this.smtpPasswordName = this.registerString("smtpPasswordName", "datarouter/email/smtpPassword");
        this.smtpPassword = cachedSecretFactory.cacheSharedSecretString(this.smtpPasswordName, "");
        this.emailLinkHostPort = this.registerString("emailLinkHostPort", "localhost:8443");
        this.includeLogo = this.registerBoolean("includeLogo", true);
        this.logoImgSrc = this.registerString("logoImgSrc", "");
    }

    public DatarouterEmailHostDetails getDatarouterEmailHostDetails() {
        if (((Boolean)this.useRemoteSmtp.get()).booleanValue()) {
            return new DatarouterEmailHostDetails((String)this.smtpHost.get(), (Integer)this.smtpPort.get(), (String)this.smtpUsername.get(), (String)this.smtpPassword.get());
        }
        return new DatarouterEmailHostDetails(DEFAULT_SMTP_HOST, DEFAULT_SMTP_PORT, "", "");
    }

    public static class DatarouterEmailHostDetails {
        public final String smtpHost;
        public final int smtpPort;
        public final String smtpUsername;
        public final String smtpPassword;

        public DatarouterEmailHostDetails(String smtpHost, int smtpPort, String smtpUsername, String smtpPassword) {
            this.smtpHost = smtpHost;
            this.smtpPort = smtpPort;
            this.smtpUsername = smtpUsername;
            this.smtpPassword = smtpPassword;
        }
    }
}

