/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.changelog.service;

import io.datarouter.changelog.config.DatarouterChangelogPaths;
import io.datarouter.email.html.J2HtmlDatarouterEmailBuilder;
import io.datarouter.email.html.J2HtmlEmailTable;
import io.datarouter.instrumentation.changelog.ChangelogRecorder;
import io.datarouter.storage.config.properties.ServerName;
import io.datarouter.util.tuple.Twin;
import io.datarouter.web.config.service.ServiceName;
import io.datarouter.web.email.DatarouterHtmlEmailService;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ChangelogEmailService {
    @Inject
    private ServiceName serviceName;
    @Inject
    private DatarouterHtmlEmailService htmlEmailService;
    @Inject
    private DatarouterChangelogPaths paths;
    @Inject
    private ServerName serverName;

    public void sendEmail(ChangelogRecorder.DatarouterChangelogDto dto) {
        String primaryHref = this.htmlEmailService.startLinkBuilder().withLocalPath(this.paths.datarouter.changelog.viewAll).build();
        J2HtmlDatarouterEmailBuilder emailBuilder = this.htmlEmailService.startEmailBuilder().withTitle("Changelog - " + dto.changelogType).withTitleHref(primaryHref).withContent(this.makeEmailContent(dto.changelogType, dto.name, dto.action, dto.username, dto.comment.orElse(""))).fromAdmin().toAdmin(dto.includeMainDatarouterAdmin).toSubscribers(dto.includeSubscribers).to(dto.username);
        this.htmlEmailService.trySendJ2Html(emailBuilder);
    }

    private ContainerTag<?> makeEmailContent(String changelogType, String name, String action, String username, String comment) {
        List<Twin> rows = List.of(new Twin((Object)"Service", (Object)this.serviceName.get()), new Twin((Object)"ServerName", (Object)this.serverName.get()), new Twin((Object)"ChangelogType", (Object)changelogType), new Twin((Object)"Name", (Object)name), new Twin((Object)"Action", (Object)action), new Twin((Object)"Username", (Object)username), new Twin((Object)"Comment", (Object)comment));
        return new J2HtmlEmailTable().withColumn(new J2HtmlEmailTable.J2HtmlEmailTableColumn(null, row -> ChangelogEmailService.makeDivBoldRight((String)row.getLeft()))).withColumn(new J2HtmlEmailTable.J2HtmlEmailTableColumn(null, row -> ChangelogEmailService.makeSpanWhiteSpacePre((String)row.getRight()))).build(rows);
    }

    private static DomContent makeDivBoldRight(String text) {
        return TagCreator.div((String)text).withStyle("font-weight:bold;text-align:right;");
    }

    private static DomContent makeSpanWhiteSpacePre(String text) {
        return TagCreator.span((String)text).withStyle("white-space:pre");
    }
}

