/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.changelog.web;

import io.datarouter.changelog.storage.Changelog;
import io.datarouter.changelog.storage.ChangelogDao;
import io.datarouter.changelog.storage.ChangelogKey;
import io.datarouter.httpclient.client.DatarouterService;
import io.datarouter.instrumentation.changelog.ChangelogDto;
import io.datarouter.instrumentation.changelog.ChangelogRecorder;
import io.datarouter.util.time.ZonedDateFormaterTool;
import io.datarouter.web.handler.BaseHandler;
import io.datarouter.web.handler.mav.Mav;
import io.datarouter.web.handler.types.Param;
import io.datarouter.web.handler.types.optional.OptionalString;
import io.datarouter.web.html.form.HtmlForm;
import io.datarouter.web.html.j2html.J2HtmlLegendTable;
import io.datarouter.web.html.j2html.bootstrap4.Bootstrap4FormHtml;
import io.datarouter.web.html.j2html.bootstrap4.Bootstrap4PageFactory;
import io.datarouter.web.user.session.CurrentUserSessionInfoService;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import java.time.ZoneId;
import java.util.Date;
import java.util.Optional;
import javax.inject.Inject;
import javax.servlet.ServletRequest;

public class EditChangelogHandler
extends BaseHandler {
    public static final String P_reversedDateMs = "reversedDateMs";
    public static final String P_changelogType = "changelogType";
    public static final String P_name = "name";
    public static final String P_note = "note";
    private static final String P_submitAction = "submitAction";
    @Inject
    private ChangelogDao dao;
    @Inject
    private Bootstrap4PageFactory pageFactory;
    @Inject
    private CurrentUserSessionInfoService sessionInfoService;
    @Inject
    private ChangelogRecorder recorder;
    @Inject
    private DatarouterService datarouterService;

    @BaseHandler.Handler(defaultHandler=true)
    public Mav edit(@Param(value="reversedDateMs") Long reversedDateMs, @Param(value="changelogType") String changelogType, @Param(value="name") String name, @Param(value="note") OptionalString note, @Param(value="submitAction") OptionalString submitAction) {
        ChangelogKey key = new ChangelogKey(reversedDateMs, changelogType, name);
        Changelog changelog = this.dao.get(key);
        ContainerTag table = new J2HtmlLegendTable().withClass("table table-sm border table-striped").withSingleRow(false).withEntry("Date", this.getDate(changelog)).withEntry("Changelog Type", ((ChangelogKey)changelog.getKey()).getChangelogType()).withEntry("Name", ((ChangelogKey)changelog.getKey()).getName()).withEntry("Action", changelog.getAction()).withEntry("Username", changelog.getUsername()).withEntry("Comment", Optional.ofNullable(changelog.getComment()).orElse("")).withEntry("Note", Optional.ofNullable(changelog.getNote()).orElse("")).build();
        HtmlForm form = new HtmlForm().withMethod("post");
        form.addTextAreaField().withDisplay("Note (Optional)").withName(P_note).withPlaceholder(Optional.ofNullable(changelog.getNote()).orElse("")).withValue((String)note.orElse(null));
        form.addButton().withDisplay("update").withValue("anything");
        if (submitAction.isEmpty() || form.hasErrors()) {
            return this.pageFactory.startBuilder(this.request).withTitle("Manual Changelog").withContent(Html.makeContent(table, form)).buildMav();
        }
        note.ifPresent(newNote -> {
            changelog.setNote((String)newNote);
            ChangelogDto dto = changelog.toDto(this.datarouterService.getServiceName());
            this.recorder.update(dto);
        });
        return this.pageFactory.preformattedMessage(this.request, "Updated changelog entry.");
    }

    private String getDate(Changelog row) {
        ZoneId zoneId = this.sessionInfoService.getZoneId((ServletRequest)this.request);
        Long reversedDateMs = ((ChangelogKey)row.getKey()).getReversedDateMs();
        Date date = new Date(Long.MAX_VALUE - reversedDateMs);
        return ZonedDateFormaterTool.formatDateWithZone((Date)date, (ZoneId)zoneId);
    }

    private static class Html {
        private Html() {
        }

        public static ContainerTag<?> makeContent(ContainerTag<?> table, HtmlForm htmlForm) {
            ContainerTag form = (ContainerTag)Bootstrap4FormHtml.render((HtmlForm)htmlForm).withClass("card card-body bg-light");
            return (ContainerTag)TagCreator.div((DomContent[])new DomContent[]{TagCreator.h2((String)"Edit Changelog"), table, form, TagCreator.br()}).withClass("container mt-3");
        }
    }
}

